/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func;

import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.intellij.func.parser.FuncParserDefinition;
import org.ton.intellij.func.psi.FuncBlockStatement;
import org.ton.intellij.func.psi.FuncElementTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/ton/intellij/func/FuncBraceMatcher;", "Lcom/intellij/lang/PairedBraceMatcher;", "()V", "pairs", "", "Lcom/intellij/lang/BracePair;", "[Lcom/intellij/lang/BracePair;", "getCodeConstructStart", "", "file", "Lcom/intellij/psi/PsiFile;", "openingBraceOffset", "getPairs", "()[Lcom/intellij/lang/BracePair;", "isPairedBracesAllowedBeforeType", "", "lbraceType", "Lcom/intellij/psi/tree/IElementType;", "contextType", "intellij-ton"})
public final class FuncBraceMatcher
implements PairedBraceMatcher {
    @NotNull
    private final BracePair[] pairs;

    public FuncBraceMatcher() {
        BracePair[] bracePairArray = new BracePair[]{new BracePair(FuncElementTypes.LBRACE, FuncElementTypes.RBRACE, true), new BracePair(FuncElementTypes.LPAREN, FuncElementTypes.RPAREN, false), new BracePair(FuncElementTypes.LBRACK, FuncElementTypes.RBRACK, false)};
        this.pairs = bracePairArray;
    }

    @NotNull
    public BracePair[] getPairs() {
        return this.pairs;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        Intrinsics.checkNotNullParameter((Object)lbraceType, (String)"lbraceType");
        return FuncParserDefinition.Companion.getWHITE_SPACE_OR_COMMENT_BIT_SET().contains(contextType) || Intrinsics.areEqual((Object)contextType, (Object)FuncElementTypes.COLON) || Intrinsics.areEqual((Object)contextType, (Object)FuncElementTypes.SEMICOLON) || Intrinsics.areEqual((Object)contextType, (Object)FuncElementTypes.COMMA) || Intrinsics.areEqual((Object)contextType, (Object)FuncElementTypes.RPAREN) || Intrinsics.areEqual((Object)contextType, (Object)FuncElementTypes.RBRACK) || Intrinsics.areEqual((Object)contextType, (Object)FuncElementTypes.RBRACE) || Intrinsics.areEqual((Object)contextType, (Object)FuncElementTypes.LBRACE);
    }

    public int getCodeConstructStart(@Nullable PsiFile file, int openingBraceOffset) {
        int n;
        PsiElement element;
        PsiFile psiFile = file;
        Object object = element = psiFile != null ? psiFile.findElementAt(openingBraceOffset) : null;
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof FuncBlockStatement) {
            TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange((PsiElement)((FuncBlockStatement)parent).getParent());
            n = textRange != null ? textRange.getStartOffset() : openingBraceOffset;
        } else {
            n = openingBraceOffset;
        }
        return n;
    }
}

