/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.doc;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.intellij.func.doc.FuncDocMarkdownFlavourDescriptor;
import org.ton.intellij.func.doc.FuncDocumentationProviderKt;
import org.ton.intellij.func.doc.psi.FuncDocComment;
import org.ton.intellij.func.highlighting.FuncColor;
import org.ton.intellij.func.psi.FuncAtomicType;
import org.ton.intellij.func.psi.FuncFile;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncFunctionParameter;
import org.ton.intellij.func.psi.FuncHoleType;
import org.ton.intellij.func.psi.FuncPrimitiveType;
import org.ton.intellij.func.psi.FuncTensorType;
import org.ton.intellij.func.psi.FuncTupleType;
import org.ton.intellij.func.psi.FuncTupleTypeItem;
import org.ton.intellij.func.psi.FuncType;
import org.ton.intellij.func.psi.FuncTypeIdentifier;
import org.ton.intellij.func.psi.FuncTypeParameter;
import org.ton.intellij.func.psi.impl.FuncFunctionImplKt;
import org.ton.intellij.func.stub.FuncFunctionParameterStub;
import org.ton.intellij.markdown.MarkdownDocAstBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\bH\u0016J\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J(\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u001b\u001a\u00020\u0004*\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u0004*\u00060\u001cj\u0002`\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u0004*\u00060\u001cj\u0002`\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u0004*\u00060\u001cj\u0002`\u001d2\u0006\u0010'\u001a\u00020(H\u0002\u00a8\u0006*"}, d2={"Lorg/ton/intellij/func/doc/FuncDocumentationProvider;", "Lcom/intellij/lang/documentation/AbstractDocumentationProvider;", "()V", "collectDocComments", "", "file", "Lcom/intellij/psi/PsiFile;", "sink", "Ljava/util/function/Consumer;", "Lcom/intellij/psi/PsiDocCommentBase;", "generateDoc", "", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "generateRenderedDoc", "comment", "getCommentText", "Lcom/intellij/psi/PsiComment;", "getComments", "getDocumentationElementForLink", "psiManager", "Lcom/intellij/psi/PsiManager;", "link", "context", "getQuickNavigateInfo", "renderElement", "renderFunction", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "function", "Lorg/ton/intellij/func/psi/FuncFunction;", "renderFunctionParameter", "param", "Lorg/ton/intellij/func/psi/FuncFunctionParameter;", "renderType", "type", "Lorg/ton/intellij/func/psi/FuncType;", "renderTypeParameter", "typeParameter", "Lorg/ton/intellij/func/psi/FuncTypeParameter;", "Companion", "intellij-ton"})
@SourceDebugExtension(value={"SMAP\nFuncDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FuncDocumentationProvider.kt\norg/ton/intellij/func/doc/FuncDocumentationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1855#2,2:221\n*S KotlinDebug\n*F\n+ 1 FuncDocumentationProvider.kt\norg/ton/intellij/func/doc/FuncDocumentationProvider\n*L\n55#1:221,2\n*E\n"})
public final class FuncDocumentationProvider
extends AbstractDocumentationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String getQuickNavigateInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        StringBuilder stringBuilder;
        if (element == null) {
            return null;
        }
        String string = this.renderElement(element, originalElement);
        if (string == null) {
            return null;
        }
        String renderedElement = string;
        StringBuilder $this$getQuickNavigateInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getQuickNavigateInfo_u24lambda_u240.append("<div class='definition'><pre>");
        $this$getQuickNavigateInfo_u24lambda_u240.append(renderedElement);
        $this$getQuickNavigateInfo_u24lambda_u240.append("</pre></div>");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Nullable
    public String generateDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        StringBuilder stringBuilder;
        if (element == null) {
            return null;
        }
        String string = this.renderElement(element, originalElement);
        if (string == null) {
            return null;
        }
        String renderedElement = string;
        StringBuilder $this$generateDoc_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateDoc_u24lambda_u241.append("<div class='definition'><pre>");
        $this$generateDoc_u24lambda_u241.append(renderedElement);
        $this$generateDoc_u24lambda_u241.append("</pre></div>");
        PsiComment doc = this.getComments(element);
        if (doc != null) {
            $this$generateDoc_u24lambda_u241.append("<div class='content'>");
            $this$generateDoc_u24lambda_u241.append(this.getCommentText(doc));
            $this$generateDoc_u24lambda_u241.append("</div>");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        return Companion.resolve(link, context);
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull Consumer<? super PsiDocCommentBase> sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        if (!(file instanceof FuncFile)) {
            return;
        }
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
        Iterable $this$forEach$iv = (Iterable)syntaxTraverser;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (!(it instanceof FuncDocComment)) continue;
            sink.accept((PsiDocCommentBase)it);
        }
    }

    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        if (!(comment instanceof FuncDocComment)) {
            return null;
        }
        CharSequence charSequence = ((FuncDocComment)comment).getNode().getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
        return MarkdownDocAstBuilder.Companion.renderHtml(charSequence, ";;;", new FuncDocMarkdownFlavourDescriptor(null, 1, null));
    }

    private final PsiComment getComments(PsiElement element) {
        FuncFunction funcFunction = element instanceof FuncFunction ? (FuncFunction)element : null;
        PsiElement psiElement = funcFunction != null ? funcFunction.getFirstChild() : null;
        return psiElement instanceof PsiComment ? (PsiComment)psiElement : null;
    }

    private final String getCommentText(PsiComment comment) {
        CharSequence charSequence = comment.getNode().getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
        return MarkdownDocAstBuilder.Companion.renderHtml(charSequence, ";;;", new FuncDocMarkdownFlavourDescriptor(null, 1, null));
    }

    @Nullable
    public final String renderElement(@Nullable PsiElement element, @Nullable PsiElement context) {
        String string;
        PsiElement psiElement = element;
        if (psiElement == null) {
            string = null;
        } else if (psiElement instanceof FuncFunction) {
            StringBuilder stringBuilder;
            StringBuilder $this$renderElement_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            this.renderFunction($this$renderElement_u24lambda_u243, (FuncFunction)element);
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string = null;
        }
        return string;
    }

    public final void renderFunction(@NotNull StringBuilder $this$renderFunction, @NotNull FuncFunction function) {
        Intrinsics.checkNotNullParameter((Object)$this$renderFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        List<FuncTypeParameter> list = function.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameterList(...)");
        List<FuncTypeParameter> typeParameterList = list;
        if (!((Collection)typeParameterList).isEmpty()) {
            TextAttributes textAttributes = FuncColor.KEYWORD.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderFunction, textAttributes, "forall");
            $this$renderFunction.append("&nbsp;");
            CollectionsKt.joinTo$default((Iterable)typeParameterList, (Appendable)$this$renderFunction, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncTypeParameter, CharSequence>(this){
                final /* synthetic */ FuncDocumentationProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(FuncTypeParameter it) {
                    StringBuilder stringBuilder;
                    FuncDocumentationProvider funcDocumentationProvider = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    FuncDocumentationProvider.access$renderTypeParameter(funcDocumentationProvider, $this$invoke_u24lambda_u240, it);
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    return string;
                }
            }), (int)62, null);
            $this$renderFunction.append("&nbsp;");
            $this$renderFunction.append("->");
            $this$renderFunction.append("&nbsp;");
        }
        FuncType funcType = function.getType();
        Intrinsics.checkNotNullExpressionValue((Object)funcType, (String)"getType(...)");
        this.renderType($this$renderFunction, funcType);
        $this$renderFunction.append("&nbsp;");
        if (FuncFunctionImplKt.isMutable(function)) {
            $this$renderFunction.append("~");
        }
        TextAttributes textAttributes = FuncColor.FUNCTION_DECLARATION.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
        FuncDocumentationProviderKt.access$appendStyledSpan($this$renderFunction, textAttributes, function.getName());
        TextAttributes textAttributes2 = FuncColor.PARENTHESES.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"<get-attributes>(...)");
        FuncDocumentationProviderKt.access$appendStyledSpan($this$renderFunction, textAttributes2, "(");
        List<FuncFunctionParameter> list2 = function.getFunctionParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFunctionParameterList(...)");
        CollectionsKt.joinTo$default((Iterable)list2, (Appendable)$this$renderFunction, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncFunctionParameter, CharSequence>(this){
            final /* synthetic */ FuncDocumentationProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(FuncFunctionParameter param) {
                StringBuilder stringBuilder;
                FuncDocumentationProvider funcDocumentationProvider = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)param);
                FuncDocumentationProvider.access$renderFunctionParameter(funcDocumentationProvider, $this$invoke_u24lambda_u240, param);
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }
        }), (int)62, null);
        TextAttributes textAttributes3 = FuncColor.PARENTHESES.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"<get-attributes>(...)");
        FuncDocumentationProviderKt.access$appendStyledSpan($this$renderFunction, textAttributes3, ")");
        if (FuncFunctionImplKt.isImpure(function)) {
            $this$renderFunction.append("&nbsp;");
            TextAttributes textAttributes4 = FuncColor.KEYWORD.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes4, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderFunction, textAttributes4, "impure");
        }
    }

    private final void renderFunctionParameter(StringBuilder $this$renderFunctionParameter, FuncFunctionParameter param) {
        String name;
        FuncAtomicType type = param.getAtomicType();
        if (type != null) {
            this.renderType($this$renderFunctionParameter, type);
        }
        if ((name = param.getName()) != null) {
            if (type != null) {
                $this$renderFunctionParameter.append("&nbsp;");
            }
            $this$renderFunctionParameter.append(name);
        }
    }

    private final void renderTypeParameter(StringBuilder $this$renderTypeParameter, FuncTypeParameter typeParameter) {
        TextAttributes textAttributes = FuncColor.TYPE_PARAMETER.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
        FuncDocumentationProviderKt.access$appendStyledSpan($this$renderTypeParameter, textAttributes, typeParameter.getName());
    }

    private final void renderType(StringBuilder $this$renderType, FuncType type) {
        FuncType funcType = type;
        if (funcType instanceof FuncTypeIdentifier) {
            TextAttributes textAttributes = FuncColor.TYPE_PARAMETER.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderType, textAttributes, ((FuncTypeIdentifier)type).getIdentifier().getText());
        } else if (funcType instanceof FuncPrimitiveType) {
            TextAttributes textAttributes = FuncColor.KEYWORD.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderType, textAttributes, ((FuncPrimitiveType)type).getText());
        } else if (funcType instanceof FuncTupleType) {
            TextAttributes textAttributes = FuncColor.BRACKETS.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderType, textAttributes, "[");
            List<FuncTupleTypeItem> list = ((FuncTupleType)type).getTupleTypeItemList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTupleTypeItemList(...)");
            CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$renderType, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncTupleTypeItem, CharSequence>(this){
                final /* synthetic */ FuncDocumentationProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(FuncTupleTypeItem it) {
                    StringBuilder stringBuilder;
                    FuncDocumentationProvider funcDocumentationProvider = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    FuncType funcType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)funcType, (String)"getType(...)");
                    FuncDocumentationProvider.access$renderType(funcDocumentationProvider, $this$invoke_u24lambda_u240, funcType);
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    return string;
                }
            }), (int)62, null);
            TextAttributes textAttributes2 = FuncColor.BRACKETS.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderType, textAttributes2, "]");
        } else if (funcType instanceof FuncTensorType) {
            TextAttributes textAttributes = FuncColor.PARENTHESES.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderType, textAttributes, "(");
            List<FuncType> list = ((FuncTensorType)type).getTypeList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeList(...)");
            CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$renderType, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncType, CharSequence>(this){
                final /* synthetic */ FuncDocumentationProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(FuncType it) {
                    StringBuilder stringBuilder;
                    FuncDocumentationProvider funcDocumentationProvider = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    FuncDocumentationProvider.access$renderType(funcDocumentationProvider, $this$invoke_u24lambda_u240, it);
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    return string;
                }
            }), (int)62, null);
            TextAttributes textAttributes3 = FuncColor.PARENTHESES.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"<get-attributes>(...)");
            FuncDocumentationProviderKt.access$appendStyledSpan($this$renderType, textAttributes3, ")");
        } else if (funcType instanceof FuncHoleType) {
            if (Intrinsics.areEqual((Object)((FuncHoleType)type).getText(), (Object)"var")) {
                TextAttributes textAttributes = FuncColor.KEYWORD.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
                FuncDocumentationProviderKt.access$appendStyledSpan($this$renderType, textAttributes, "var");
            } else {
                $this$renderType.append("_");
            }
        } else {
            $this$renderType.append(type);
        }
    }

    public static final /* synthetic */ void access$renderTypeParameter(FuncDocumentationProvider $this, StringBuilder $receiver, FuncTypeParameter typeParameter) {
        $this.renderTypeParameter($receiver, typeParameter);
    }

    public static final /* synthetic */ void access$renderFunctionParameter(FuncDocumentationProvider $this, StringBuilder $receiver, FuncFunctionParameter param) {
        $this.renderFunctionParameter($receiver, param);
    }

    public static final /* synthetic */ void access$renderType(FuncDocumentationProvider $this, StringBuilder $receiver, FuncType type) {
        $this.renderType($receiver, type);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\b"}, d2={"Lorg/ton/intellij/func/doc/FuncDocumentationProvider$Companion;", "", "()V", "resolve", "Lcom/intellij/psi/PsiElement;", "link", "", "context", "intellij-ton"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiElement resolve(@Nullable String link, @Nullable PsiElement context) {
            if (link == null) {
                return null;
            }
            if (context instanceof FuncFunction) {
                Object v1;
                StubBasedPsiElement<FuncFunctionParameterStub> it;
                Iterable iterable;
                block9: {
                    List<FuncFunctionParameter> list = ((FuncFunction)context).getFunctionParameterList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getFunctionParameterList(...)");
                    iterable = list;
                    for (Object object2 : iterable) {
                        it = (FuncFunctionParameter)object2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)link)) continue;
                        v1 = object2;
                        break block9;
                    }
                    v1 = null;
                }
                PsiElement resolved = v1;
                if (resolved == null) {
                    Object object;
                    block10: {
                        List<FuncTypeParameter> list = ((FuncFunction)context).getTypeParameterList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameterList(...)");
                        iterable = list;
                        for (Object object2 : iterable) {
                            it = (FuncTypeParameter)object2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)link)) continue;
                            object = object2;
                            break block10;
                        }
                        object = null;
                    }
                    resolved = (PsiElement)object;
                }
                if (resolved == null) {
                    FuncFunction funcFunction;
                    iterable = ((FuncFunction)context).getContainingFile();
                    FuncFile file = iterable instanceof FuncFile ? (FuncFile)((Object)iterable) : null;
                    Object object = file;
                    if (object != null && (object = object.getFunctions()) != null) {
                        Object v5;
                        block11: {
                            Object object2;
                            object2 = (Iterable)object;
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                Object t = iterator.next();
                                FuncFunction it2 = (FuncFunction)t;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)link)) continue;
                                v5 = t;
                                break block11;
                            }
                            v5 = null;
                        }
                        funcFunction = v5;
                    } else {
                        funcFunction = null;
                    }
                    resolved = funcFunction;
                }
                return resolved;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

