/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.func.highlighting.FuncColor;
import org.ton.intellij.func.psi.FuncBlockStatement;
import org.ton.intellij.func.psi.FuncConstVar;
import org.ton.intellij.func.psi.FuncElementTypes;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncFunctionParameter;
import org.ton.intellij.func.psi.FuncGlobalVar;
import org.ton.intellij.func.psi.FuncReferenceExpression;
import org.ton.intellij.func.psi.FuncTypeIdentifier;
import org.ton.intellij.func.psi.FuncTypeParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/ton/intellij/func/highlighting/FuncAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "highlight", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij-ton"})
public final class FuncAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElement psiElement = element;
        if (psiElement instanceof FuncTypeParameter) {
            PsiElement psiElement2 = ((FuncTypeParameter)element).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"<get-identifier>(...)");
            this.highlight(psiElement2, holder, FuncColor.TYPE_PARAMETER.getTextAttributesKey());
            return;
        }
        if (psiElement instanceof FuncTypeIdentifier) {
            PsiElement psiElement3 = ((FuncTypeIdentifier)element).getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getIdentifier(...)");
            this.highlight(psiElement3, holder, FuncColor.TYPE_PARAMETER.getTextAttributesKey());
            return;
        }
        if (psiElement instanceof FuncGlobalVar) {
            PsiElement psiElement4 = ((FuncGlobalVar)element).getIdentifier();
            if (psiElement4 == null) {
                return;
            }
            this.highlight(psiElement4, holder, FuncColor.GLOBAL_VARIABLE.getTextAttributesKey());
            return;
        }
        if (psiElement instanceof FuncConstVar) {
            PsiElement psiElement5 = ((FuncConstVar)element).getIdentifier();
            if (psiElement5 == null) {
                return;
            }
            this.highlight(psiElement5, holder, FuncColor.CONSTANT.getTextAttributesKey());
            return;
        }
        if (psiElement instanceof FuncFunctionParameter) {
            PsiElement psiElement6 = ((FuncFunctionParameter)element).getIdentifier();
            if (psiElement6 == null) {
                return;
            }
            this.highlight(psiElement6, holder, FuncColor.PARAMETER.getTextAttributesKey());
            return;
        }
        if (psiElement instanceof FuncReferenceExpression) {
            IElementType iElementType = ((FuncReferenceExpression)element).getNode().getTreeParent().getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)FuncElementTypes.CALL_EXPRESSION)) {
                PsiElement psiElement7 = ((FuncReferenceExpression)element).getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement7, (String)"<get-identifier>(...)");
                this.highlight(psiElement7, holder, FuncColor.FUNCTION_STATIC.getTextAttributesKey());
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)FuncElementTypes.METHOD_CALL)) {
                PsiElement psiElement8 = ((FuncReferenceExpression)element).getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement8, (String)"<get-identifier>(...)");
                this.highlight(psiElement8, holder, FuncColor.FUNCTION_CALL.getTextAttributesKey());
            } else {
                PsiReference psiReference = ((FuncReferenceExpression)element).getReference();
                if (psiReference == null || (psiReference = psiReference.resolve()) == null) {
                    psiReference = element;
                }
                PsiReference resolved = psiReference;
                Ref.ObjectRef color = new Ref.ObjectRef();
                PsiTreeUtil.treeWalkUp((PsiElement)resolved, null, (arg_0, arg_1) -> FuncAnnotator.annotate$lambda$0((Function2)new Function2<PsiElement, PsiElement, Boolean>((Ref.ObjectRef<TextAttributesKey>)color){
                    final /* synthetic */ Ref.ObjectRef<TextAttributesKey> $color;
                    {
                        this.$color = $color;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(PsiElement scope, PsiElement psiElement) {
                        PsiElement psiElement2 = scope;
                        this.$color.element = psiElement2 instanceof FuncBlockStatement ? FuncColor.LOCAL_VARIABLE.getTextAttributesKey() : (psiElement2 instanceof FuncConstVar ? FuncColor.CONSTANT.getTextAttributesKey() : (psiElement2 instanceof FuncGlobalVar ? FuncColor.GLOBAL_VARIABLE.getTextAttributesKey() : (psiElement2 instanceof FuncFunctionParameter ? FuncColor.PARAMETER.getTextAttributesKey() : null)));
                        return this.$color.element == null;
                    }
                }, arg_0, arg_1));
                TextAttributesKey textAttributesKey = (TextAttributesKey)color.element;
                if (textAttributesKey != null) {
                    TextAttributesKey it = textAttributesKey;
                    boolean bl = false;
                    PsiElement psiElement9 = ((FuncReferenceExpression)element).getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement9, (String)"<get-identifier>(...)");
                    this.highlight(psiElement9, holder, it);
                }
            }
            return;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof FuncFunction && Intrinsics.areEqual((Object)element, (Object)((FuncFunction)parent).getNameIdentifier())) {
            this.highlight(element, holder, FuncColor.FUNCTION_DECLARATION.getTextAttributesKey());
        }
    }

    private final void highlight(PsiElement element, AnnotationHolder holder, TextAttributesKey key) {
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element.getTextRange()).textAttributes(key).create();
    }

    private static final boolean annotate$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }
}

