/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.ide;

import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.func.lexer.FuncLexer;
import org.ton.intellij.func.parser.FuncParserDefinition;
import org.ton.intellij.func.psi.FuncConstVar;
import org.ton.intellij.func.psi.FuncElementTypes;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncGlobalVar;
import org.ton.intellij.func.psi.FuncTokenTypeKt;
import org.ton.intellij.func.psi.FuncTypeParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/ton/intellij/func/ide/FuncFindUsagesProvider;", "Lcom/intellij/lang/findUsages/FindUsagesProvider;", "()V", "canFindUsagesFor", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getDescriptiveName", "", "element", "getHelpId", "getNodeText", "useFullName", "getType", "getWordsScanner", "Lcom/intellij/lang/cacheBuilder/WordsScanner;", "intellij-ton"})
public final class FuncFindUsagesProvider
implements FindUsagesProvider {
    @NotNull
    public WordsScanner getWordsScanner() {
        IElementType[] iElementTypeArray = new IElementType[]{FuncElementTypes.IDENTIFIER};
        return (WordsScanner)new DefaultWordsScanner((Lexer)new FuncLexer(), TokenSet.create((IElementType[])iElementTypeArray), FuncTokenTypeKt.getFUNC_COMMENTS(), FuncParserDefinition.Companion.getSTRING_LITERALS());
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return true;
    }

    @NotNull
    public String getHelpId(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof FuncFunction) {
            string = "function";
        } else if (psiElement instanceof FuncConstVar) {
            string = "constant";
        } else if (psiElement instanceof FuncGlobalVar) {
            string = "global var";
        } else if (psiElement instanceof FuncTypeParameter) {
            string = "type parameter";
        } else {
            return "<TYPE " + element + ">";
        }
        return string;
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
        return string;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
        return string;
    }
}

