/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.ide;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.func.psi.FuncCallArgument;
import org.ton.intellij.func.psi.FuncCallExpression;
import org.ton.intellij.func.psi.FuncExpression;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncFunctionParameter;
import org.ton.intellij.func.psi.FuncMethodCall;
import org.ton.intellij.func.psi.FuncReferenceExpression;
import org.ton.intellij.func.psi.FuncTensorExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u0007*\u00020\u0011H\u0002J\u001a\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u0007*\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/ton/intellij/func/ide/FuncParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "()V", "getDefaultBlackList", "", "", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "element", "Lcom/intellij/psi/PsiElement;", "resolveFunction", "Lorg/ton/intellij/func/psi/FuncFunction;", "Lorg/ton/intellij/func/psi/FuncReferenceExpression;", "toArgList", "Lorg/ton/intellij/func/psi/FuncExpression;", "kotlin.jvm.PlatformType", "Lorg/ton/intellij/func/psi/FuncCallArgument;", "intellij-ton"})
@SourceDebugExtension(value={"SMAP\nFuncParameterHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FuncParameterHintsProvider.kt\norg/ton/intellij/func/ide/FuncParameterHintsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1864#2,3:56\n*S KotlinDebug\n*F\n+ 1 FuncParameterHintsProvider.kt\norg/ton/intellij/func/ide/FuncParameterHintsProvider\n*L\n37#1:56,3\n*E\n"})
public final class FuncParameterHintsProvider
implements InlayParameterHintsProvider {
    @NotNull
    public Set<String> getDefaultBlackList() {
        return SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FuncFunction function = null;
        int argumentOffset = 0;
        List<FuncExpression> arguments = null;
        PsiElement psiElement = element;
        if (psiElement instanceof FuncCallExpression) {
            boolean bl;
            FuncReferenceExpression funcReferenceExpression = ((FuncCallExpression)element).getReferenceExpression();
            Intrinsics.checkNotNullExpressionValue((Object)funcReferenceExpression, (String)"getReferenceExpression(...)");
            FuncFunction funcFunction = this.resolveFunction(funcReferenceExpression);
            if (funcFunction == null) {
                return CollectionsKt.emptyList();
            }
            function = funcFunction;
            String string = ((FuncCallExpression)element).getReferenceExpression().getName();
            if (string != null) {
                Character c = StringsKt.getOrNull((CharSequence)string, (int)0);
                char c2 = '~';
                bl = c != null && c.charValue() == c2;
            } else {
                bl = false;
            }
            argumentOffset = bl ? 1 : 0;
            FuncCallArgument funcCallArgument = ((FuncCallExpression)element).getCallArgument();
            Intrinsics.checkNotNullExpressionValue((Object)funcCallArgument, (String)"getCallArgument(...)");
            arguments = this.toArgList(funcCallArgument);
        } else if (psiElement instanceof FuncMethodCall) {
            FuncReferenceExpression funcReferenceExpression = ((FuncMethodCall)element).getReferenceExpression();
            Intrinsics.checkNotNullExpressionValue((Object)funcReferenceExpression, (String)"getReferenceExpression(...)");
            FuncFunction funcFunction = this.resolveFunction(funcReferenceExpression);
            if (funcFunction == null) {
                return CollectionsKt.emptyList();
            }
            function = funcFunction;
            argumentOffset = 1;
            FuncCallArgument funcCallArgument = ((FuncMethodCall)element).getCallArgument();
            Intrinsics.checkNotNullExpressionValue((Object)funcCallArgument, (String)"getCallArgument(...)");
            arguments = this.toArgList(funcCallArgument);
        } else {
            return CollectionsKt.emptyList();
        }
        List<FuncFunctionParameter> list = function.getFunctionParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFunctionParameterList(...)");
        List<FuncFunctionParameter> parameters = list;
        ArrayList<InlayInfo> result = new ArrayList<InlayInfo>();
        Iterable $this$forEachIndexed$iv = arguments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void funcExpression;
            FuncFunctionParameter parameter;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FuncExpression funcExpression2 = (FuncExpression)item$iv;
            int index = n;
            boolean bl = false;
            if ((FuncFunctionParameter)CollectionsKt.getOrNull(parameters, (int)(index + argumentOffset)) == null) {
                return result;
            }
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            result.add(new InlayInfo(parameterName, funcExpression.getTextOffset()));
        }
        return result;
    }

    private final FuncFunction resolveFunction(FuncReferenceExpression $this$resolveFunction) {
        PsiReference psiReference = $this$resolveFunction.getReference();
        PsiElement psiElement = psiReference != null ? psiReference.resolve() : null;
        return psiElement instanceof FuncFunction ? (FuncFunction)psiElement : null;
    }

    private final List<FuncExpression> toArgList(FuncCallArgument $this$toArgList) {
        FuncExpression funcExpression = $this$toArgList.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)funcExpression, (String)"getExpression(...)");
        return this.toArgList(funcExpression);
    }

    private final List<FuncExpression> toArgList(FuncExpression $this$toArgList) {
        List<FuncExpression> list;
        if ($this$toArgList instanceof FuncTensorExpression) {
            List<FuncExpression> list2 = ((FuncTensorExpression)$this$toArgList).getExpressionList();
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            list = CollectionsKt.listOf((Object)$this$toArgList);
        }
        return list;
    }
}

