/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.ide.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.func.FuncIcons;
import org.ton.intellij.func.ide.completion.FuncReferenceCompletionProvider;
import org.ton.intellij.func.psi.FuncAtomicType;
import org.ton.intellij.func.psi.FuncCatch;
import org.ton.intellij.func.psi.FuncConstVar;
import org.ton.intellij.func.psi.FuncElement;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncFunctionParameter;
import org.ton.intellij.func.psi.FuncReferenceExpression;
import org.ton.intellij.func.psi.FuncVarExpression;
import org.ton.intellij.func.psi.impl.FuncReference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0012\u0013\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J*\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/ton/intellij/func/ide/completion/FuncReferenceCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillVariantsByReference", "originalElement", "Lorg/ton/intellij/func/psi/FuncElement;", "reference", "Lcom/intellij/psi/PsiReference;", "file", "Lcom/intellij/psi/PsiFile;", "CatchVariableRenderer", "ConstRenderer", "FunctionParameterRenderer", "FunctionRenderer", "MyProcessor", "VariableRenderer", "intellij-ton"})
public final class FuncReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        FuncReferenceExpression expression = (FuncReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), FuncReferenceExpression.class);
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile;
        if (expression != null) {
            this.fillVariantsByReference(expression, expression.getReference(), originalFile, result);
        }
    }

    private final void fillVariantsByReference(FuncElement originalElement, PsiReference reference, PsiFile file, CompletionResultSet result) {
        if (reference == null) {
            return;
        }
        PsiReference psiReference = reference;
        if (psiReference instanceof PsiMultiReference) {
            Object[] it = ((PsiMultiReference)reference).getReferences();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Comparator comparator = PsiMultiReference.COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"COMPARATOR");
            ArraysKt.sortWith((Object[])it, (Comparator)comparator);
            this.fillVariantsByReference(originalElement, (PsiReference)ArraysKt.firstOrNull((Object[])it), file, result);
            return;
        }
        if (psiReference instanceof FuncReference) {
            ((FuncReference)reference).processResolveVariants(new MyProcessor(originalElement, result), false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/ton/intellij/func/ide/completion/FuncReferenceCompletionProvider$CatchVariableRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "catchStatement", "Lorg/ton/intellij/func/psi/FuncCatch;", "(Lorg/ton/intellij/func/psi/FuncCatch;)V", "getCatchStatement", "()Lorg/ton/intellij/func/psi/FuncCatch;", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij-ton"})
    private static final class CatchVariableRenderer
    extends LookupElementRenderer<LookupElement> {
        @NotNull
        private final FuncCatch catchStatement;

        public CatchVariableRenderer(@NotNull FuncCatch catchStatement) {
            Intrinsics.checkNotNullParameter((Object)catchStatement, (String)"catchStatement");
            this.catchStatement = catchStatement;
        }

        @NotNull
        public final FuncCatch getCatchStatement() {
            return this.catchStatement;
        }

        public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
            LookupElementPresentation lookupElementPresentation;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            LookupElementPresentation $this$renderElement_u24lambda_u240 = lookupElementPresentation = presentation;
            boolean bl = false;
            $this$renderElement_u24lambda_u240.setIcon(FuncIcons.INSTANCE.getVARIABLE());
            $this$renderElement_u24lambda_u240.setTypeGrayed(true);
            $this$renderElement_u24lambda_u240.setItemText(element.getLookupString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/ton/intellij/func/ide/completion/FuncReferenceCompletionProvider$ConstRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "variable", "Lorg/ton/intellij/func/psi/FuncConstVar;", "(Lorg/ton/intellij/func/psi/FuncConstVar;)V", "getVariable", "()Lorg/ton/intellij/func/psi/FuncConstVar;", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij-ton"})
    private static final class ConstRenderer
    extends LookupElementRenderer<LookupElement> {
        @NotNull
        private final FuncConstVar variable;

        public ConstRenderer(@NotNull FuncConstVar variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.variable = variable;
        }

        @NotNull
        public final FuncConstVar getVariable() {
            return this.variable;
        }

        public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
            LookupElementPresentation lookupElementPresentation;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            LookupElementPresentation $this$renderElement_u24lambda_u240 = lookupElementPresentation = presentation;
            boolean bl = false;
            $this$renderElement_u24lambda_u240.setIcon(FuncIcons.INSTANCE.getCONSTANT());
            $this$renderElement_u24lambda_u240.setTypeGrayed(true);
            $this$renderElement_u24lambda_u240.setItemText(element.getLookupString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/ton/intellij/func/ide/completion/FuncReferenceCompletionProvider$FunctionParameterRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij-ton"})
    private static final class FunctionParameterRenderer
    extends LookupElementRenderer<LookupElement> {
        @NotNull
        public static final FunctionParameterRenderer INSTANCE = new FunctionParameterRenderer();

        private FunctionParameterRenderer() {
        }

        public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
            LookupElementPresentation lookupElementPresentation;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            PsiElement psiElement = element.getPsiElement();
            FuncFunctionParameter funcFunctionParameter = psiElement instanceof FuncFunctionParameter ? (FuncFunctionParameter)psiElement : null;
            if (funcFunctionParameter == null) {
                return;
            }
            FuncFunctionParameter psiElement2 = funcFunctionParameter;
            LookupElementPresentation $this$renderElement_u24lambda_u240 = lookupElementPresentation = presentation;
            boolean bl = false;
            $this$renderElement_u24lambda_u240.setIcon(FuncIcons.INSTANCE.getPARAMETER());
            $this$renderElement_u24lambda_u240.setItemText(element.getLookupString());
            $this$renderElement_u24lambda_u240.setTypeGrayed(true);
            FuncAtomicType funcAtomicType = psiElement2.getAtomicType();
            $this$renderElement_u24lambda_u240.setTypeText(funcAtomicType != null ? funcAtomicType.getText() : null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/ton/intellij/func/ide/completion/FuncReferenceCompletionProvider$FunctionRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij-ton"})
    private static final class FunctionRenderer
    extends LookupElementRenderer<LookupElement> {
        @NotNull
        public static final FunctionRenderer INSTANCE = new FunctionRenderer();

        private FunctionRenderer() {
        }

        public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            PsiElement psiElement = element.getPsiElement();
            if (!(psiElement instanceof FuncFunction)) {
                return;
            }
            presentation.setIcon(FuncIcons.INSTANCE.getFUNCTION());
            presentation.setItemText(element.getLookupString());
            List<FuncFunctionParameter> list = ((FuncFunction)psiElement).getFunctionParameterList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFunctionParameterList(...)");
            presentation.setTailText(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)renderElement.1.INSTANCE, (int)24, null));
            presentation.setTypeGrayed(true);
            presentation.setTypeText(((FuncFunction)psiElement).getType().getText());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/ton/intellij/func/ide/completion/FuncReferenceCompletionProvider$MyProcessor;", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "originalElement", "Lorg/ton/intellij/func/psi/FuncElement;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "(Lorg/ton/intellij/func/psi/FuncElement;Lcom/intellij/codeInsight/completion/CompletionResultSet;)V", "getOriginalElement", "()Lorg/ton/intellij/func/psi/FuncElement;", "processedNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getResult", "()Lcom/intellij/codeInsight/completion/CompletionResultSet;", "execute", "", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "intellij-ton"})
    private static final class MyProcessor
    implements PsiScopeProcessor {
        @NotNull
        private final FuncElement originalElement;
        @NotNull
        private final CompletionResultSet result;
        @NotNull
        private final HashSet<String> processedNames;

        public MyProcessor(@NotNull FuncElement originalElement, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.originalElement = originalElement;
            this.result = result;
            this.processedNames = new HashSet();
        }

        @NotNull
        public final FuncElement getOriginalElement() {
            return this.originalElement;
        }

        @NotNull
        public final CompletionResultSet getResult() {
            return this.result;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/ton/intellij/func/ide/completion/FuncReferenceCompletionProvider$VariableRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "variable", "Lorg/ton/intellij/func/psi/FuncVarExpression;", "(Lorg/ton/intellij/func/psi/FuncVarExpression;)V", "getVariable", "()Lorg/ton/intellij/func/psi/FuncVarExpression;", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij-ton"})
    private static final class VariableRenderer
    extends LookupElementRenderer<LookupElement> {
        @NotNull
        private final FuncVarExpression variable;

        public VariableRenderer(@NotNull FuncVarExpression variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.variable = variable;
        }

        @NotNull
        public final FuncVarExpression getVariable() {
            return this.variable;
        }

        public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
            LookupElementPresentation lookupElementPresentation;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            LookupElementPresentation $this$renderElement_u24lambda_u240 = lookupElementPresentation = presentation;
            boolean bl = false;
            $this$renderElement_u24lambda_u240.setIcon(FuncIcons.INSTANCE.getVARIABLE());
            $this$renderElement_u24lambda_u240.setTypeGrayed(true);
            $this$renderElement_u24lambda_u240.setItemText(element.getLookupString());
        }
    }
}

