/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.ide.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.intellij.func.ide.formatter.AbstractFuncBlock;
import org.ton.intellij.func.psi.FuncElementTypes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001dH\u0002R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/ton/intellij/func/ide/formatter/FuncFormattingBlock;", "Lorg/ton/intellij/func/ide/formatter/AbstractFuncBlock;", "node", "Lcom/intellij/lang/ASTNode;", "spacingBuilder", "Lcom/intellij/formatting/SpacingBuilder;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "indent", "Lcom/intellij/formatting/Indent;", "childIndent", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/SpacingBuilder;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Indent;Lcom/intellij/formatting/Indent;)V", "BRACES_TOKEN_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "a", "", "buildChildren", "", "Lcom/intellij/formatting/Block;", "calcIndent", "child", "calcWrap", "createBlock", "Lcom/intellij/formatting/ASTBlock;", "indentIfNotBrace", "example", "", "intellij-ton"})
public final class FuncFormattingBlock
extends AbstractFuncBlock {
    @NotNull
    private final TokenSet BRACES_TOKEN_SET;

    public FuncFormattingBlock(@NotNull ASTNode node, @NotNull SpacingBuilder spacingBuilder, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Indent childIndent) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)spacingBuilder, (String)"spacingBuilder");
        super(node, spacingBuilder, wrap, alignment, indent, childIndent);
        IElementType[] iElementTypeArray = new IElementType[]{FuncElementTypes.LBRACE, FuncElementTypes.RBRACE, FuncElementTypes.LBRACK, FuncElementTypes.RBRACK, FuncElementTypes.LPAREN, FuncElementTypes.RPAREN};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.BRACES_TOKEN_SET = tokenSet;
    }

    public /* synthetic */ FuncFormattingBlock(ASTNode aSTNode, SpacingBuilder spacingBuilder, Wrap wrap, Alignment alignment, Indent indent, Indent indent2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            wrap = null;
        }
        if ((n & 8) != 0) {
            alignment = null;
        }
        if ((n & 0x10) != 0) {
            indent = null;
        }
        if ((n & 0x20) != 0) {
            indent2 = null;
        }
        this(aSTNode, spacingBuilder, wrap, alignment, indent, indent2);
    }

    @NotNull
    protected List<Block> buildChildren() {
        LinkedList<ASTBlock> childrenBlocks = new LinkedList<ASTBlock>();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ASTBlock block2 = this.createBlock(child);
            if (block2 == null) continue;
            childrenBlocks.add(block2);
        }
        return childrenBlocks;
    }

    private final ASTBlock createBlock(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)TokenType.WHITE_SPACE)) {
            return null;
        }
        Indent indent = this.calcIndent(node);
        if (indent == null) {
            return null;
        }
        Indent indent2 = indent;
        Indent childIndent = Intrinsics.areEqual((Object)node.getElementType(), (Object)FuncElementTypes.BLOCK_STATEMENT) ? Indent.getNormalIndent() : null;
        Wrap wrap = this.calcWrap(node);
        return (ASTBlock)new FuncFormattingBlock(node, this.getSpacingBuilder(), wrap, null, indent2, childIndent);
    }

    private final int example(int $this$example) {
        return $this$example;
    }

    private final void a() {
        int a = 1;
        this.example(this.example(this.example(this.example(a))));
        this.example(this.example(this.example(this.example(a))));
    }

    private final Indent calcIndent(ASTNode child) {
        IElementType iElementType = child.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        ASTNode parent = child.getTreeParent();
        IElementType iElementType2 = parent.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
        IElementType parentType = iElementType2;
        if (Intrinsics.areEqual((Object)parentType, (Object)FuncElementTypes.BLOCK_STATEMENT)) {
            return this.indentIfNotBrace(child);
        }
        if (Intrinsics.areEqual((Object)parentType, (Object)FuncElementTypes.TENSOR_EXPRESSION) && !Intrinsics.areEqual((Object)type, (Object)FuncElementTypes.LPAREN) && !Intrinsics.areEqual((Object)type, (Object)FuncElementTypes.RPAREN)) {
            return Indent.getNormalIndent();
        }
        if (Intrinsics.areEqual((Object)type, (Object)FuncElementTypes.PRIMITIVE_TYPE_EXPRESSION) || Intrinsics.areEqual((Object)type, (Object)FuncElementTypes.HOLE_TYPE_EXPRESSION)) {
            return Indent.getNoneIndent();
        }
        return Indent.getNoneIndent();
    }

    private final Wrap calcWrap(ASTNode child) {
        IElementType iElementType = child.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        IElementType iElementType2 = child.getTreeParent().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
        IElementType parentType = iElementType2;
        return null;
    }

    private final Indent indentIfNotBrace(ASTNode child) {
        Indent indent;
        if (this.BRACES_TOKEN_SET.contains(child.getElementType())) {
            Indent indent2 = Indent.getNoneIndent();
            indent = indent2;
            Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"getNoneIndent(...)");
        } else {
            Indent indent3 = Indent.getNormalIndent();
            indent = indent3;
            Intrinsics.checkNotNullExpressionValue((Object)indent3, (String)"getNormalIndent(...)");
        }
        return indent;
    }
}

