/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.ide.quickdoc;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.HtmlSyntaxInfoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.intellij.func.highlighting.FuncColor;
import org.ton.intellij.func.ide.quickdoc.MarkdownNode;
import org.ton.intellij.func.psi.FuncAtomicType;
import org.ton.intellij.func.psi.FuncElement;
import org.ton.intellij.func.psi.FuncExpression;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncFunctionParameter;
import org.ton.intellij.func.psi.FuncHoleType;
import org.ton.intellij.func.psi.FuncHoleTypeExpression;
import org.ton.intellij.func.psi.FuncPrimitiveType;
import org.ton.intellij.func.psi.FuncPrimitiveTypeExpression;
import org.ton.intellij.func.psi.FuncReferenceExpression;
import org.ton.intellij.func.psi.FuncTensorType;
import org.ton.intellij.func.psi.FuncTokenTypeKt;
import org.ton.intellij.func.psi.FuncTupleType;
import org.ton.intellij.func.psi.FuncTupleTypeItem;
import org.ton.intellij.func.psi.FuncType;
import org.ton.intellij.func.psi.FuncTypeIdentifier;
import org.ton.intellij.func.psi.FuncTypeParameter;
import org.ton.intellij.func.psi.FuncVarExpression;
import org.ton.intellij.func.psi.impl.FuncFunctionImplKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J$\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0003J&\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003J \u0010\u001b\u001a\u00020\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0010J\u001f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H$0#\"\b\b\u0000\u0010$*\u00020\u0003*\u0002H$\u00a2\u0006\u0002\u0010%J\u0016\u0010&\u001a\u00020\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u00020\u001c*\u00060\u001dj\u0002`\u001e2\u0006\u00100\u001a\u000201R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u00062"}, d2={"Lorg/ton/intellij/func/ide/quickdoc/FuncDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "navigatable", "Lcom/intellij/pom/Navigatable;", "getNavigatable", "()Lcom/intellij/pom/Navigatable;", "getOriginalElement", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "computeDocumentationHint", "", "computeLocalDocumentation", "quickNavigation", "", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "createPointer", "Lcom/intellij/model/Pointer;", "findDocumentationComment", "renderElement", "Lkotlin/Pair;", "appendStyledSpan", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "value", "createSmartPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "E", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/SmartPsiElementPointer;", "renderFunction", "function", "Lorg/ton/intellij/func/psi/FuncFunction;", "renderFunctionParameter", "param", "Lorg/ton/intellij/func/psi/FuncFunctionParameter;", "renderType", "type", "Lorg/ton/intellij/func/psi/FuncType;", "renderTypeParameter", "typeParameter", "Lorg/ton/intellij/func/psi/FuncTypeParameter;", "intellij-ton"})
public final class FuncDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final PsiElement element;
    @Nullable
    private final PsiElement originalElement;

    public FuncDocumentationTarget(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.originalElement = originalElement;
    }

    @NotNull
    public final PsiElement getElement() {
        return this.element;
    }

    @Nullable
    public final PsiElement getOriginalElement() {
        return this.originalElement;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        return UtilKt.targetPresentation((PsiElement)this.element);
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        SmartPsiElementPointer<PsiElement> elementPtr = this.createSmartPointer(this.element);
        PsiElement psiElement = this.originalElement;
        SmartPsiElementPointer<PsiElement> originalElementPtr = psiElement != null ? this.createSmartPointer(psiElement) : null;
        return () -> FuncDocumentationTarget.createPointer$lambda$0(elementPtr, originalElementPtr);
    }

    @Nullable
    public String computeDocumentationHint() {
        return this.computeLocalDocumentation(this.element, this.originalElement, true);
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        DocumentationResult.Documentation documentation;
        String string = this.computeLocalDocumentation(this.element, this.originalElement, false);
        if (string != null) {
            String it = string;
            boolean bl = false;
            documentation = DocumentationResult.Companion.documentation(it);
        } else {
            documentation = null;
        }
        return (DocumentationResult)documentation;
    }

    @Nullable
    public Navigatable getNavigatable() {
        PsiElement psiElement = this.element;
        return psiElement instanceof Navigatable ? (Navigatable)psiElement : null;
    }

    @NotNull
    public final <E extends PsiElement> SmartPsiElementPointer<E> createSmartPointer(@NotNull E $this$createSmartPointer) {
        Intrinsics.checkNotNullParameter($this$createSmartPointer, (String)"<this>");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)$this$createSmartPointer.getProject()).createSmartPsiElementPointer($this$createSmartPointer);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        return smartPsiElementPointer;
    }

    private final String computeLocalDocumentation(PsiElement element, PsiElement originalElement, boolean quickNavigation) {
        StringBuilder stringBuilder;
        Pair<PsiElement, String> pair = this.renderElement(element, originalElement);
        if (pair == null) {
            return null;
        }
        Pair<PsiElement, String> pair2 = pair;
        PsiElement resolvedElement = (PsiElement)pair2.component1();
        String elementHtml = (String)pair2.component2();
        StringBuilder $this$computeLocalDocumentation_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$computeLocalDocumentation_u24lambda_u242.append(elementHtml);
        String doc = this.findDocumentationComment(resolvedElement);
        if (!StringsKt.isBlank((CharSequence)doc)) {
            $this$computeLocalDocumentation_u24lambda_u242.append("<div class='content'>");
            $this$computeLocalDocumentation_u24lambda_u242.append(doc);
            $this$computeLocalDocumentation_u24lambda_u242.append("</div>");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String findDocumentationComment(@NotNull PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        if (!(originalElement instanceof FuncElement)) {
            return "";
        }
        LinkedList<String> result = new LinkedList<String>();
        PsiElement element = ((FuncElement)originalElement).getPrevSibling();
        while (FuncTokenTypeKt.getFUNC_DOC_COMMENTS().contains(PsiTreeUtilKt.getElementType((PsiElement)element)) || element instanceof PsiWhiteSpace) {
            if (FuncTokenTypeKt.getFUNC_DOC_COMMENTS().contains(PsiTreeUtilKt.getElementType((PsiElement)element))) {
                String string = element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence charSequence = string;
                Regex regex = new Regex("[!; ]+");
                String string2 = "";
                String commentText = regex.replaceFirst(charSequence, string2);
                result.add(commentText);
            }
            element = element.getPrevSibling();
        }
        String comment = CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversedMutable((List)result), (CharSequence)"\n ", null, null, (int)0, null, null, (int)62, null);
        ASTNode markdownTree = new MarkdownParser((MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, false, false, 7, null)).buildMarkdownTreeFromString(comment);
        MarkdownNode markdownNode = new MarkdownNode(markdownTree, null, comment, originalElement);
        return markdownNode.toHtml();
    }

    @Nullable
    public final Pair<PsiElement, String> renderElement(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        PsiElement psiElement = element;
        boolean bl = false;
        PsiElement psiElement2 = element;
        if (psiElement2 instanceof FuncReferenceExpression) {
            PsiElement resolved;
            PsiReference psiReference = ((FuncReferenceExpression)element).getReference();
            Object object = resolved = psiReference != null ? psiReference.resolve() : null;
            if (resolved != null) {
                return this.renderElement(resolved, originalElement);
            }
            FuncVarExpression funcVarExpression = (FuncVarExpression)PsiTreeUtil.getParentOfType((PsiElement)element, FuncVarExpression.class);
            if (funcVarExpression == null) {
                return null;
            }
            FuncVarExpression funcVarExpression2 = funcVarExpression;
            Intrinsics.checkNotNull((Object)funcVarExpression2);
            FuncVarExpression varExpr = funcVarExpression2;
            FuncExpression left = varExpr.getExpressionList().get(0);
            FuncExpression right = varExpr.getExpressionList().get(1);
            FuncExpression funcExpression = left;
            if (funcExpression instanceof FuncPrimitiveTypeExpression) {
                FuncPrimitiveType funcPrimitiveType = ((FuncPrimitiveTypeExpression)left).getPrimitiveType();
                Intrinsics.checkNotNullExpressionValue((Object)funcPrimitiveType, (String)"getPrimitiveType(...)");
                this.renderType((StringBuilder)$this$renderElement_u24lambda_u243, funcPrimitiveType);
            } else if (funcExpression instanceof FuncHoleTypeExpression) {
                FuncHoleType funcHoleType = ((FuncHoleTypeExpression)left).getHoleType();
                Intrinsics.checkNotNullExpressionValue((Object)funcHoleType, (String)"getHoleType(...)");
                this.renderType((StringBuilder)$this$renderElement_u24lambda_u243, funcHoleType);
            } else {
                $this$renderElement_u24lambda_u243.append(left.getText());
            }
            $this$renderElement_u24lambda_u243.append("&nbsp;");
            $this$renderElement_u24lambda_u243.append(right.getText());
        } else if (psiElement2 instanceof FuncFunction) {
            $this$renderElement_u24lambda_u243.append("<div class='definition'><pre>");
            this.renderFunction((StringBuilder)$this$renderElement_u24lambda_u243, (FuncFunction)element);
            $this$renderElement_u24lambda_u243.append("</pre></div>");
        } else if (psiElement2 instanceof FuncFunctionParameter) {
            $this$renderElement_u24lambda_u243.append("<div class='definition'><pre>");
            this.renderFunctionParameter((StringBuilder)$this$renderElement_u24lambda_u243, (FuncFunctionParameter)element);
            $this$renderElement_u24lambda_u243.append("</pre></div>");
        } else if (psiElement2 instanceof FuncTypeParameter) {
            $this$renderElement_u24lambda_u243.append("<div class='definition'><pre>");
            this.renderTypeParameter((StringBuilder)$this$renderElement_u24lambda_u243, (FuncTypeParameter)element);
            $this$renderElement_u24lambda_u243.append("</pre></div>");
        } else {
            element.toString();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return TuplesKt.to((Object)psiElement, (Object)string);
    }

    public final void renderFunction(@NotNull StringBuilder $this$renderFunction, @NotNull FuncFunction function) {
        Intrinsics.checkNotNullParameter((Object)$this$renderFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        List<FuncTypeParameter> list = function.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameterList(...)");
        List<FuncTypeParameter> typeParameterList = list;
        if (!((Collection)typeParameterList).isEmpty()) {
            TextAttributes textAttributes = FuncColor.KEYWORD.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderFunction, textAttributes, "forall");
            $this$renderFunction.append("&nbsp;");
            CollectionsKt.joinTo$default((Iterable)typeParameterList, (Appendable)$this$renderFunction, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncTypeParameter, CharSequence>(this){
                final /* synthetic */ FuncDocumentationTarget this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(FuncTypeParameter it) {
                    StringBuilder stringBuilder;
                    FuncDocumentationTarget funcDocumentationTarget = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    funcDocumentationTarget.renderTypeParameter($this$invoke_u24lambda_u240, it);
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    return string;
                }
            }), (int)62, null);
            $this$renderFunction.append("&nbsp;");
            $this$renderFunction.append("->");
            $this$renderFunction.append("&nbsp;");
        }
        FuncType funcType = function.getType();
        Intrinsics.checkNotNullExpressionValue((Object)funcType, (String)"getType(...)");
        this.renderType($this$renderFunction, funcType);
        $this$renderFunction.append("&nbsp;");
        if (FuncFunctionImplKt.isMutable(function)) {
            $this$renderFunction.append("~");
        }
        TextAttributes textAttributes = FuncColor.FUNCTION_DECLARATION.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
        this.appendStyledSpan($this$renderFunction, textAttributes, function.getName());
        TextAttributes textAttributes2 = FuncColor.PARENTHESES.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"<get-attributes>(...)");
        this.appendStyledSpan($this$renderFunction, textAttributes2, "(");
        List<FuncFunctionParameter> list2 = function.getFunctionParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFunctionParameterList(...)");
        CollectionsKt.joinTo$default((Iterable)list2, (Appendable)$this$renderFunction, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncFunctionParameter, CharSequence>(this){
            final /* synthetic */ FuncDocumentationTarget this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(FuncFunctionParameter param) {
                StringBuilder stringBuilder;
                FuncDocumentationTarget funcDocumentationTarget = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)param);
                funcDocumentationTarget.renderFunctionParameter($this$invoke_u24lambda_u240, param);
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }
        }), (int)62, null);
        TextAttributes textAttributes3 = FuncColor.PARENTHESES.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"<get-attributes>(...)");
        this.appendStyledSpan($this$renderFunction, textAttributes3, ")");
        if (FuncFunctionImplKt.isImpure(function)) {
            $this$renderFunction.append("&nbsp;");
            TextAttributes textAttributes4 = FuncColor.KEYWORD.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes4, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderFunction, textAttributes4, "impure");
        }
    }

    public final void renderFunctionParameter(@NotNull StringBuilder $this$renderFunctionParameter, @NotNull FuncFunctionParameter param) {
        String name;
        Intrinsics.checkNotNullParameter((Object)$this$renderFunctionParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        FuncAtomicType type = param.getAtomicType();
        if (type != null) {
            this.renderType($this$renderFunctionParameter, type);
        }
        if ((name = param.getName()) != null) {
            if (type != null) {
                $this$renderFunctionParameter.append("&nbsp;");
            }
            $this$renderFunctionParameter.append(name);
        }
    }

    public final void renderTypeParameter(@NotNull StringBuilder $this$renderTypeParameter, @NotNull FuncTypeParameter typeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$renderTypeParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        TextAttributes textAttributes = FuncColor.TYPE_PARAMETER.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
        this.appendStyledSpan($this$renderTypeParameter, textAttributes, typeParameter.getName());
    }

    public final void renderType(@NotNull StringBuilder $this$renderType, @NotNull FuncType type) {
        Intrinsics.checkNotNullParameter((Object)$this$renderType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        FuncType funcType = type;
        if (funcType instanceof FuncTypeIdentifier) {
            TextAttributes textAttributes = FuncColor.TYPE_PARAMETER.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderType, textAttributes, ((FuncTypeIdentifier)type).getIdentifier().getText());
        } else if (funcType instanceof FuncPrimitiveType) {
            TextAttributes textAttributes = FuncColor.KEYWORD.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderType, textAttributes, ((FuncPrimitiveType)type).getText());
        } else if (funcType instanceof FuncTupleType) {
            TextAttributes textAttributes = FuncColor.BRACKETS.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderType, textAttributes, "[");
            List<FuncTupleTypeItem> list = ((FuncTupleType)type).getTupleTypeItemList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTupleTypeItemList(...)");
            CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$renderType, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncTupleTypeItem, CharSequence>(this){
                final /* synthetic */ FuncDocumentationTarget this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(FuncTupleTypeItem it) {
                    StringBuilder stringBuilder;
                    FuncDocumentationTarget funcDocumentationTarget = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    FuncType funcType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)funcType, (String)"getType(...)");
                    funcDocumentationTarget.renderType($this$invoke_u24lambda_u240, funcType);
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    return string;
                }
            }), (int)62, null);
            TextAttributes textAttributes2 = FuncColor.BRACKETS.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes2, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderType, textAttributes2, "]");
        } else if (funcType instanceof FuncTensorType) {
            TextAttributes textAttributes = FuncColor.PARENTHESES.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderType, textAttributes, "(");
            List<FuncType> list = ((FuncTensorType)type).getTypeList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeList(...)");
            CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$renderType, null, null, null, (int)0, null, (Function1)((Function1)new Function1<FuncType, CharSequence>(this){
                final /* synthetic */ FuncDocumentationTarget this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(FuncType it) {
                    StringBuilder stringBuilder;
                    FuncDocumentationTarget funcDocumentationTarget = this.this$0;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    funcDocumentationTarget.renderType($this$invoke_u24lambda_u240, it);
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                    return string;
                }
            }), (int)62, null);
            TextAttributes textAttributes3 = FuncColor.PARENTHESES.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"<get-attributes>(...)");
            this.appendStyledSpan($this$renderType, textAttributes3, ")");
        } else if (funcType instanceof FuncHoleType) {
            if (Intrinsics.areEqual((Object)((FuncHoleType)type).getText(), (Object)"var")) {
                TextAttributes textAttributes = FuncColor.KEYWORD.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"<get-attributes>(...)");
                this.appendStyledSpan($this$renderType, textAttributes, "var");
            } else {
                $this$renderType.append("_");
            }
        } else {
            $this$renderType.append(type);
        }
    }

    public final void appendStyledSpan(@NotNull StringBuilder $this$appendStyledSpan, @NotNull TextAttributes attributes, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$appendStyledSpan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        HtmlSyntaxInfoUtil.appendStyledSpan((StringBuilder)$this$appendStyledSpan, (TextAttributes)attributes, (String)value, (float)1.0f);
    }

    private static final FuncDocumentationTarget createPointer$lambda$0(SmartPsiElementPointer $elementPtr, SmartPsiElementPointer $originalElementPtr) {
        Intrinsics.checkNotNullParameter((Object)$elementPtr, (String)"$elementPtr");
        PsiElement psiElement = $elementPtr.dereference();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        SmartPsiElementPointer smartPsiElementPointer = $originalElementPtr;
        return new FuncDocumentationTarget(element, (PsiElement)(smartPsiElementPointer != null ? smartPsiElementPointer.dereference() : null));
    }
}

