/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.ide.quickdoc;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationSettings;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.intellij.func.FuncLanguage;
import org.ton.intellij.func.doc.FuncDocumentationProvider;
import org.ton.intellij.func.ide.quickdoc.MarkdownNode;
import org.ton.intellij.func.ide.quickdoc.MarkdownNodeKt;
import org.ton.intellij.func.psi.FuncFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u0006J&\u0010$\u001a\u00020%2\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0(\u0012\u0004\u0012\u00020%0'R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/ton/intellij/func/ide/quickdoc/MarkdownNode;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "parent", "content", "", "owner", "Lcom/intellij/psi/PsiElement;", "(Lorg/intellij/markdown/ast/ASTNode;Lorg/ton/intellij/func/ide/quickdoc/MarkdownNode;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "children", "", "getChildren", "()Ljava/util/List;", "getContent", "()Ljava/lang/String;", "endOffset", "", "getEndOffset", "()I", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getOwner", "()Lcom/intellij/psi/PsiElement;", "getParent", "()Lorg/ton/intellij/func/ide/quickdoc/MarkdownNode;", "startOffset", "getStartOffset", "text", "getText", "type", "Lorg/intellij/markdown/IElementType;", "getType", "()Lorg/intellij/markdown/IElementType;", "child", "toHtml", "visit", "", "action", "Lkotlin/Function2;", "Lkotlin/Function0;", "intellij-ton"})
@SourceDebugExtension(value={"SMAP\nMarkdownNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownNode.kt\norg/ton/intellij/func/ide/quickdoc/MarkdownNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n1549#2:366\n1620#2,3:367\n288#2,2:370\n*S KotlinDebug\n*F\n+ 1 MarkdownNode.kt\norg/ton/intellij/func/ide/quickdoc/MarkdownNode\n*L\n33#1:366\n33#1:367,3\n39#1:370,2\n*E\n"})
public final class MarkdownNode {
    @NotNull
    private final ASTNode node;
    @Nullable
    private final MarkdownNode parent;
    @NotNull
    private final String content;
    @NotNull
    private final PsiElement owner;
    @NotNull
    private final List<MarkdownNode> children;

    /*
     * WARNING - void declaration
     */
    public MarkdownNode(@NotNull ASTNode node, @Nullable MarkdownNode parent, @NotNull String content, @NotNull PsiElement owner) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.node = node;
        this.parent = parent;
        this.content = content;
        this.owner = owner;
        Iterable iterable = this.node.getChildren();
        MarkdownNode markdownNode = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MarkdownNode((ASTNode)it, this, this.content, this.owner));
        }
        markdownNode.children = (List)destination$iv$iv;
    }

    @NotNull
    public final ASTNode getNode() {
        return this.node;
    }

    @Nullable
    public final MarkdownNode getParent() {
        return this.parent;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final PsiElement getOwner() {
        return this.owner;
    }

    @NotNull
    public final List<MarkdownNode> getChildren() {
        return this.children;
    }

    public final int getEndOffset() {
        return this.node.getEndOffset();
    }

    public final int getStartOffset() {
        return this.node.getStartOffset();
    }

    @NotNull
    public final IElementType getType() {
        return this.node.getType();
    }

    @NotNull
    public final String getText() {
        String string = this.content.substring(this.getStartOffset(), this.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @Nullable
    public final MarkdownNode child(@NotNull IElementType type) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Iterable $this$firstOrNull$iv = this.children;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MarkdownNode it = (MarkdownNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)type)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void visit(@NotNull Function2<? super MarkdownNode, ? super Function0<Unit>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke((Object)this, (Object)new Function0<Unit>(this, action){
            final /* synthetic */ MarkdownNode this$0;
            final /* synthetic */ Function2<MarkdownNode, Function0<Unit>, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(0);
            }

            public final void invoke() {
                for (MarkdownNode child : this.this$0.getChildren()) {
                    child.visit(this.$action);
                }
            }
        });
    }

    @NotNull
    public final String toHtml() {
        if (Intrinsics.areEqual((Object)this.node.getType(), (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            return this.getText();
        }
        Ref.ObjectRef currentCodeFenceLang = new Ref.ObjectRef();
        currentCodeFenceLang.element = "func";
        StringBuilder sb = new StringBuilder();
        this.visit((Function2<? super MarkdownNode, ? super Function0<Unit>, Unit>)((Function2)new Function2<MarkdownNode, Function0<? extends Unit>, Unit>(sb, this, (Ref.ObjectRef<String>)currentCodeFenceLang){
            final /* synthetic */ StringBuilder $sb;
            final /* synthetic */ MarkdownNode this$0;
            final /* synthetic */ Ref.ObjectRef<String> $currentCodeFenceLang;
            {
                this.$sb = $sb;
                this.this$0 = $receiver;
                this.$currentCodeFenceLang = $currentCodeFenceLang;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MarkdownNode node, @NotNull Function0<Unit> processChildren) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(processChildren, (String)"processChildren");
                IElementType nodeType = node.getType();
                String nodeText = node.getText();
                IElementType iElementType = nodeType;
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST)) {
                    toHtml.1.invoke$wrapChildren(this.$sb, processChildren, "ul", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
                    toHtml.1.invoke$wrapChildren(this.$sb, processChildren, "ol", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "li", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.EMPH)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "em", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "strong", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.STRIKETHROUGH)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "del", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_1)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "h1", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_2)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "h2", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_3)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "h3", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_4)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "h4", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_5)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "h5", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ATX_6)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "h6", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) {
                    toHtml.1.invoke$wrapChildren$default(this.$sb, processChildren, "blockquote", false, 8, null);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH)) {
                    StringsKt.trimEnd((CharSequence)this.$sb);
                    toHtml.1.invoke$wrapChildren(this.$sb, processChildren, "p", true);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_SPAN)) {
                    String startDelimiter;
                    MarkdownNode markdownNode = node.child(MarkdownTokenTypes.BACKTICK);
                    String string = startDelimiter = markdownNode != null ? markdownNode.getText() : null;
                    if (startDelimiter != null) {
                        String string2 = node.getText().substring(startDelimiter.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                        String text = StringsKt.removeSuffix((String)string2, (CharSequence)startDelimiter);
                        this.$sb.append("<code style='font-size:" + DocumentationSettings.getMonospaceFontSizeCorrection((boolean)true) + "%;'>");
                        DocumentationSettings.InlineCodeHighlightingMode inlineCodeHighlightingMode = DocumentationSettings.getInlineCodeHighlightingMode();
                        Intrinsics.checkNotNullExpressionValue((Object)inlineCodeHighlightingMode, (String)"getInlineCodeHighlightingMode(...)");
                        Project project = this.this$0.getOwner().getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        MarkdownNodeKt.access$appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet(this.$sb, inlineCodeHighlightingMode, project, FuncLanguage.INSTANCE, text);
                        this.$sb.append("</code>");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                    StringsKt.trimEnd((CharSequence)this.$sb);
                    this.$sb.append("<pre><code style='font-size:" + DocumentationSettings.getMonospaceFontSizeCorrection((boolean)true) + "%;'>");
                    processChildren.invoke();
                    this.$sb.append("</code></pre>");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.FENCE_LANG)) {
                    this.$currentCodeFenceLang.element = nodeText;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FULL_REFERENCE_LINK)) {
                    List linkLabelContent;
                    List<MarkdownNode> list;
                    MarkdownNode linkLabelNode = node.child(MarkdownElementTypes.LINK_LABEL);
                    if (linkLabelNode != null && (list = linkLabelNode.getChildren()) != null) {
                        void $this$dropLastWhile$iv;
                        List $this$dropWhile$iv;
                        Iterable iterable = list;
                        boolean $i$f$dropWhile = false;
                        boolean yielding$iv = false;
                        ArrayList<T> list$iv = new ArrayList<T>();
                        for (T item$iv : $this$dropWhile$iv) {
                            if (yielding$iv) {
                                list$iv.add(item$iv);
                                continue;
                            }
                            MarkdownNode it = (MarkdownNode)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) continue;
                            list$iv.add(item$iv);
                            yielding$iv = true;
                        }
                        $this$dropWhile$iv = list$iv;
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv.isEmpty()) {
                            ListIterator<E> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                MarkdownNode it = (MarkdownNode)iterator$iv.previous();
                                boolean bl = false;
                                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) continue;
                                v5 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            v5 = CollectionsKt.emptyList();
                        }
                    } else {
                        v5 = linkLabelContent = null;
                    }
                    if (linkLabelContent != null) {
                        String label2 = CollectionsKt.joinToString$default((Iterable)linkLabelContent, (CharSequence)"", null, null, (int)0, null, (Function1)toHtml.label.1.INSTANCE, (int)30, null);
                        Object object = node.child(MarkdownElementTypes.LINK_TEXT);
                        if (object == null || (object = ((MarkdownNode)object).toHtml()) == null) {
                            object = label2;
                        }
                        Object linkText = object;
                        Project project = this.this$0.getOwner().getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        if (DumbService.Companion.isDumb(project)) {
                            this.$sb.append((String)linkText);
                        } else if (this.this$0.getOwner() instanceof FuncFunction) {
                            PsiElement resolved = FuncDocumentationProvider.Companion.resolve(label2, this.this$0.getOwner());
                            if (resolved != null) {
                                StringBuilder stringBuilder;
                                System.out.println((Object)("resolved = " + resolved + " (" + resolved.getText() + ")"));
                                StringBuilder $this$invoke_u24lambda_u242 = stringBuilder = new StringBuilder();
                                boolean bl = false;
                                DocumentationManagerUtil.createHyperlink((StringBuilder)$this$invoke_u24lambda_u242, (String)label2, (String)linkText, (boolean)false, (boolean)true);
                                String string = stringBuilder.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                                String hyperlink = string;
                                this.$sb.append(hyperlink);
                            } else {
                                this.$sb.append(node.getText());
                            }
                        }
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.INLINE_LINK)) {
                    String destination;
                    MarkdownNode markdownNode = node.child(MarkdownElementTypes.LINK_TEXT);
                    String label3 = markdownNode != null ? markdownNode.toHtml() : null;
                    MarkdownNode markdownNode2 = node.child(MarkdownElementTypes.LINK_DESTINATION);
                    String string = destination = markdownNode2 != null ? markdownNode2.getText() : null;
                    if (label3 != null && destination != null) {
                        this.$sb.append("<a href=\"" + destination + "\">" + label3 + "</a>");
                    } else {
                        this.$sb.append(node.getText());
                    }
                } else if (((((((((((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.COLON)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SINGLE_QUOTE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.DOUBLE_QUOTE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LPAREN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RPAREN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LBRACKET)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.RBRACKET)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EXCLAMATION_MARK)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CHECK_BOX)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.GFM_AUTOLINK)) {
                    this.$sb.append(nodeText);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_LINE) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
                    DocumentationSettings.InlineCodeHighlightingMode inlineCodeHighlightingMode;
                    boolean label3 = DocumentationSettings.isHighlightingOfCodeBlocksEnabled();
                    if (label3) {
                        inlineCodeHighlightingMode = DocumentationSettings.InlineCodeHighlightingMode.SEMANTIC_HIGHLIGHTING;
                    } else if (!label3) {
                        inlineCodeHighlightingMode = DocumentationSettings.InlineCodeHighlightingMode.NO_HIGHLIGHTING;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Project project = this.this$0.getOwner().getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Language language = MarkdownNodeKt.access$guessLanguage((String)this.$currentCodeFenceLang.element);
                    if (language == null) {
                        language = FuncLanguage.INSTANCE;
                    }
                    MarkdownNodeKt.access$appendHighlightedByLexerAndEncodedAsHtmlCodeSnippet(this.$sb, inlineCodeHighlightingMode, project, language, nodeText);
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                    IElementType parentType;
                    MarkdownNode markdownNode = node.getParent();
                    Object object = parentType = markdownNode != null ? markdownNode.getType() : null;
                    if (Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_BLOCK) || Intrinsics.areEqual((Object)parentType, (Object)MarkdownElementTypes.CODE_FENCE)) {
                        this.$sb.append("\n");
                    } else {
                        this.$sb.append(" ");
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.GT)) {
                    this.$sb.append("&gt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LT)) {
                    this.$sb.append("&lt;");
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_TEXT)) {
                    List childrenWithoutBrackets = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)node.getChildren(), (int)1), (int)1);
                    for (MarkdownNode child : childrenWithoutBrackets) {
                        this.$sb.append(child.toHtml());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EMPH)) {
                    IElementType parentNodeType;
                    MarkdownNode markdownNode = node.getParent();
                    Object object = parentNodeType = markdownNode != null ? markdownNode.getType() : null;
                    if (!Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.EMPH) && !Intrinsics.areEqual((Object)parentNodeType, (Object)MarkdownElementTypes.STRONG)) {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.TILDE)) {
                    MarkdownNode markdownNode = node.getParent();
                    if (!Intrinsics.areEqual((Object)(markdownNode != null ? markdownNode.getType() : null), (Object)GFMElementTypes.STRIKETHROUGH)) {
                        this.$sb.append(node.getText());
                    }
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)GFMElementTypes.TABLE)) {
                    List alignment = MarkdownNodeKt.access$getTableAlignment(node);
                    boolean addedBody = false;
                    this.$sb.append("<table>");
                    for (MarkdownNode child : node.getChildren()) {
                        if (Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.HEADER)) {
                            this.$sb.append("<thead>");
                            MarkdownNodeKt.access$processTableRow(this.$sb, child, "th", alignment);
                            this.$sb.append("</thead>");
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.ROW)) continue;
                        if (!addedBody) {
                            this.$sb.append("<tbody>");
                            addedBody = true;
                        }
                        MarkdownNodeKt.access$processTableRow(this.$sb, child, "td", alignment);
                    }
                    if (addedBody) {
                        this.$sb.append("</tbody>");
                    }
                    this.$sb.append("</table>");
                } else {
                    processChildren.invoke();
                }
            }

            private static final void invoke$wrapChildren(StringBuilder sb, Function0<Unit> $processChildren, String tag, boolean newline) {
                sb.append("<" + tag + ">");
                $processChildren.invoke();
                sb.append("</" + tag + ">");
                if (newline) {
                    Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append('\\n')");
                }
            }

            static /* synthetic */ void invoke$wrapChildren$default(StringBuilder stringBuilder, Function0 function0, String string, boolean bl, int n, Object object) {
                if ((n & 8) != 0) {
                    bl = false;
                }
                toHtml.1.invoke$wrapChildren(stringBuilder, (Function0<Unit>)function0, string, bl);
            }
        }));
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }
}

