/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.func.inspection.FuncInspectionBase;
import org.ton.intellij.func.psi.FuncCallArgument;
import org.ton.intellij.func.psi.FuncCallExpression;
import org.ton.intellij.func.psi.FuncElement;
import org.ton.intellij.func.psi.FuncExpression;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncFunctionParameter;
import org.ton.intellij.func.psi.FuncMethodCall;
import org.ton.intellij.func.psi.FuncTensorExpression;
import org.ton.intellij.func.psi.FuncVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J$\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\n*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/ton/intellij/func/inspection/FuncFunctionCallInspection;", "Lorg/ton/intellij/func/inspection/FuncInspectionBase;", "()V", "buildFuncVisitor", "Lorg/ton/intellij/func/psi/FuncVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "check", "", "function", "Lorg/ton/intellij/func/psi/FuncFunction;", "argument", "Lorg/ton/intellij/func/psi/FuncCallArgument;", "isMethodCall", "", "noValueForParameter", "element", "Lcom/intellij/psi/PsiElement;", "parameter", "Lorg/ton/intellij/func/psi/FuncFunctionParameter;", "tooManyArguments", "intellij-ton"})
public final class FuncFunctionCallInspection
extends FuncInspectionBase {
    @Override
    @NotNull
    protected FuncVisitor buildFuncVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new FuncVisitor(this, holder){
            final /* synthetic */ FuncFunctionCallInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitCallExpression(@NotNull FuncCallExpression o) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitCallExpression(o);
                PsiReference psiReference = o.getReferenceExpression().getReference();
                PsiElement psiElement = psiReference != null ? psiReference.resolve() : null;
                FuncFunction funcFunction = psiElement instanceof FuncFunction ? (FuncFunction)psiElement : null;
                if (funcFunction == null) {
                    return;
                }
                FuncFunction function = funcFunction;
                String string = o.getReferenceExpression().getName();
                if (string != null) {
                    Character c = StringsKt.getOrNull((CharSequence)string, (int)0);
                    char c2 = '~';
                    bl = c != null && c.charValue() == c2;
                } else {
                    bl = false;
                }
                boolean isMethodCall = bl;
                FuncCallArgument funcCallArgument = o.getCallArgument();
                Intrinsics.checkNotNullExpressionValue((Object)funcCallArgument, (String)"getCallArgument(...)");
                FuncFunctionCallInspection.access$check(this.this$0, this.$holder, function, funcCallArgument, isMethodCall);
            }

            public void visitMethodCall(@NotNull FuncMethodCall o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitMethodCall(o);
                PsiReference psiReference = o.getReferenceExpression().getReference();
                PsiElement psiElement = psiReference != null ? psiReference.resolve() : null;
                FuncFunction funcFunction = psiElement instanceof FuncFunction ? (FuncFunction)psiElement : null;
                if (funcFunction == null) {
                    return;
                }
                FuncFunction function = funcFunction;
                FuncCallArgument funcCallArgument = o.getCallArgument();
                Intrinsics.checkNotNullExpressionValue((Object)funcCallArgument, (String)"getCallArgument(...)");
                FuncFunctionCallInspection.access$check(this.this$0, this.$holder, function, funcCallArgument, true);
            }
        };
    }

    private final void check(ProblemsHolder $this$check, FuncFunction function, FuncCallArgument argument, boolean isMethodCall) {
        int expectedSize;
        List<FuncExpression> list;
        FuncExpression it = argument.getExpression();
        boolean bl = false;
        if (it instanceof FuncTensorExpression) {
            List<FuncExpression> list2 = ((FuncTensorExpression)it).getExpressionList();
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getExpressionList(...)");
        } else {
            list = CollectionsKt.listOf((Object)it);
        }
        List<FuncExpression> arguments = list;
        List<FuncFunctionParameter> list3 = function.getFunctionParameterList();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getFunctionParameterList(...)");
        List<FuncFunctionParameter> parameters = list3;
        int actualSize = arguments.size();
        int n = expectedSize = isMethodCall ? parameters.size() - 1 : parameters.size();
        if (actualSize == expectedSize) {
            return;
        }
        if (actualSize > expectedSize) {
            int n2 = actualSize;
            for (int i = expectedSize; i < n2; ++i) {
                FuncExpression funcExpression = arguments.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)funcExpression, (String)"get(...)");
                this.tooManyArguments($this$check, funcExpression);
            }
        }
        if (expectedSize > actualSize) {
            FuncExpression funcExpression = (FuncExpression)CollectionsKt.lastOrNull(arguments);
            FuncElement highlightArgument = funcExpression != null ? (FuncElement)funcExpression : (FuncElement)argument;
            int n3 = expectedSize += isMethodCall ? 1 : 0;
            for (int i = actualSize += isMethodCall ? 1 : 0; i < n3; ++i) {
                PsiElement psiElement = highlightArgument;
                FuncFunctionParameter funcFunctionParameter = parameters.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)funcFunctionParameter, (String)"get(...)");
                this.noValueForParameter($this$check, psiElement, funcFunctionParameter);
            }
        }
    }

    private final void tooManyArguments(ProblemsHolder $this$tooManyArguments, PsiElement element) {
        $this$tooManyArguments.registerProblem(element, "Too many arguments", new LocalQuickFix[0]);
    }

    private final void noValueForParameter(ProblemsHolder $this$noValueForParameter, PsiElement element, FuncFunctionParameter parameter) {
        String name = parameter.getName();
        if (name != null) {
            $this$noValueForParameter.registerProblem(element, "No value for parameter `" + name + "`", new LocalQuickFix[0]);
        } else {
            $this$noValueForParameter.registerProblem(element, "Not enough arguments", new LocalQuickFix[0]);
        }
    }

    public static final /* synthetic */ void access$check(FuncFunctionCallInspection $this, ProblemsHolder $receiver, FuncFunction function, FuncCallArgument argument, boolean isMethodCall) {
        $this.check($receiver, function, argument, isMethodCall);
    }
}

