/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.func.inspection.FuncInspectionBase;
import org.ton.intellij.func.psi.FuncAtomicType;
import org.ton.intellij.func.psi.FuncBlockStatement;
import org.ton.intellij.func.psi.FuncElement;
import org.ton.intellij.func.psi.FuncElse;
import org.ton.intellij.func.psi.FuncElseIf;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncHoleType;
import org.ton.intellij.func.psi.FuncIfStatement;
import org.ton.intellij.func.psi.FuncReturnStatement;
import org.ton.intellij.func.psi.FuncStatement;
import org.ton.intellij.func.psi.FuncTensorType;
import org.ton.intellij.func.psi.FuncType;
import org.ton.intellij.func.psi.FuncVisitor;
import org.ton.intellij.func.psi.impl.FuncBlockImplKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/ton/intellij/func/inspection/FuncMissingReturnInspection;", "Lorg/ton/intellij/func/inspection/FuncInspectionBase;", "()V", "buildFuncVisitor", "Lorg/ton/intellij/func/psi/FuncVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "check", "", "function", "Lorg/ton/intellij/func/psi/FuncFunction;", "isTerminating", "", "element", "Lorg/ton/intellij/func/psi/FuncElement;", "intellij-ton"})
public final class FuncMissingReturnInspection
extends FuncInspectionBase {
    @Override
    @NotNull
    protected FuncVisitor buildFuncVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new FuncVisitor(this, holder){
            final /* synthetic */ FuncMissingReturnInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFunction(@NotNull FuncFunction o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                FuncMissingReturnInspection.access$check(this.this$0, o, this.$holder);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void check(FuncFunction function, ProblemsHolder holder) {
        boolean bl;
        FuncBlockStatement funcBlockStatement = function.getBlockStatement();
        if (funcBlockStatement == null) {
            return;
        }
        FuncBlockStatement block2 = funcBlockStatement;
        FuncType funcType = function.getType();
        if (!(funcType instanceof FuncAtomicType)) return;
        FuncAtomicType funcAtomicType = (FuncAtomicType)funcType;
        if (funcAtomicType == null) {
            return;
        }
        FuncAtomicType atomicType = funcAtomicType;
        if (atomicType instanceof FuncHoleType) return;
        Object object = atomicType instanceof FuncTensorType ? (FuncTensorType)atomicType : null;
        if (object != null && (object = object.getTypeList()) != null) {
            if (object.isEmpty()) {
                return;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl2 = false;
        boolean isVoid = bl2;
        if (isVoid) return;
        if (this.isTerminating(block2)) {
            return;
        }
        PsiElement brace = FuncBlockImplKt.getRBrace(block2);
        PsiElement psiElement = brace;
        if (psiElement == null) {
            psiElement = block2;
        }
        holder.registerProblem(psiElement, "Missing return at end of function", new LocalQuickFix[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTerminating(FuncElement element) {
        ProgressIndicatorProvider.checkCanceled();
        FuncElement funcElement = element;
        if (funcElement == null) {
            return false;
        }
        if (funcElement instanceof FuncReturnStatement) {
            return true;
        }
        if (funcElement instanceof FuncBlockStatement) {
            List<FuncStatement> list = ((FuncBlockStatement)element).getStatementList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatementList(...)");
            v1 = this.isTerminating((FuncElement)CollectionsKt.lastOrNull(list));
            return v1;
        } else {
            if (funcElement instanceof FuncIfStatement) {
                if (!this.isTerminating(((FuncIfStatement)element).getBlockStatement())) return false;
                FuncElse funcElse = ((FuncIfStatement)element).getElse();
                if (!this.isTerminating(funcElse != null ? (FuncElement)funcElse : (FuncElement)((FuncIfStatement)element).getElseIf())) return false;
                return true;
            }
            if (funcElement instanceof FuncElse) {
                v1 = this.isTerminating(((FuncElse)element).getBlockStatement());
                return v1;
            } else {
                if (!(funcElement instanceof FuncElseIf)) return false;
                if (!this.isTerminating(((FuncElseIf)element).getBlockStatement())) return false;
                FuncElse funcElse = ((FuncElseIf)element).getElse();
                if (!this.isTerminating(funcElse != null ? (FuncElement)funcElse : (FuncElement)((FuncElseIf)element).getElseIf())) return false;
                return true;
            }
        }
    }

    public static final /* synthetic */ void access$check(FuncMissingReturnInspection $this, FuncFunction function, ProblemsHolder holder) {
        $this.check(function, holder);
    }
}

