/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.inspection;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.intellij.func.inspection.FuncAbstractApplicabilityBasedInspection;
import org.ton.intellij.func.psi.FuncBlockStatement;
import org.ton.intellij.func.psi.FuncCallArgument;
import org.ton.intellij.func.psi.FuncCallExpression;
import org.ton.intellij.func.psi.FuncCondition;
import org.ton.intellij.func.psi.FuncElement;
import org.ton.intellij.func.psi.FuncElse;
import org.ton.intellij.func.psi.FuncElseIf;
import org.ton.intellij.func.psi.FuncExpression;
import org.ton.intellij.func.psi.FuncExpressionStatement;
import org.ton.intellij.func.psi.FuncIfStatement;
import org.ton.intellij.func.psi.FuncPsiFactory;
import org.ton.intellij.func.psi.FuncStatement;
import org.ton.intellij.func.psi.impl.FuncCallArgumentKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0002H\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/ton/intellij/func/inspection/FuncReplaceGuardClauseWithFunctionCallInspection;", "Lorg/ton/intellij/func/inspection/FuncAbstractApplicabilityBasedInspection;", "Lorg/ton/intellij/func/psi/FuncIfStatement;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionText", "isApplicable", "", "getCallExpression", "Lorg/ton/intellij/func/psi/FuncCallExpression;", "replaceWith", "Lorg/ton/intellij/func/psi/FuncStatement;", "newExpression", "psiFactory", "Lorg/ton/intellij/func/psi/FuncPsiFactory;", "Companion", "intellij-ton"})
public final class FuncReplaceGuardClauseWithFunctionCallInspection
extends FuncAbstractApplicabilityBasedInspection<FuncIfStatement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String THROW_FUNCTION = "throw";

    public FuncReplaceGuardClauseWithFunctionCallInspection() {
        super(FuncIfStatement.class);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return "Replace with function call";
    }

    @Override
    @NotNull
    public String fixText(@NotNull FuncIfStatement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.getIfKeyword() != null ? "Replace with 'throw_if()' call" : (element.getIfnotKeyword() != null ? "Replace with 'throw_unless()' call" : super.fixText((FuncElement)element));
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull FuncIfStatement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return "Replace guard clause with function call";
    }

    @Override
    public boolean isApplicable(@NotNull FuncIfStatement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getCondition() == null) {
            return false;
        }
        if (element.getElse() != null || element.getElseIf() != null) {
            return false;
        }
        FuncCallExpression funcCallExpression = this.getCallExpression(element);
        if (funcCallExpression == null) {
            return false;
        }
        FuncCallExpression call = funcCallExpression;
        String calleeText = call.getReferenceExpression().getText();
        if (!Intrinsics.areEqual((Object)calleeText, (Object)THROW_FUNCTION)) {
            return false;
        }
        FuncCallArgument funcCallArgument = call.getCallArgument();
        Intrinsics.checkNotNullExpressionValue((Object)funcCallArgument, (String)"getCallArgument(...)");
        List<FuncExpression> arguments = FuncCallArgumentKt.collectArguments(funcCallArgument);
        return arguments.size() <= 1;
    }

    @Override
    public void applyTo(@NotNull FuncIfStatement element, @NotNull Project project, @Nullable Editor editor) {
        block6: {
            FuncStatement funcStatement;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (element.getElse() != null || element.getElseIf() != null) {
                return;
            }
            FuncCondition funcCondition = element.getCondition();
            if (funcCondition == null) {
                return;
            }
            FuncCondition condition = funcCondition;
            FuncCallExpression funcCallExpression = this.getCallExpression(element);
            if (funcCallExpression == null) {
                return;
            }
            FuncCallExpression call = funcCallExpression;
            FuncCallArgument funcCallArgument = call.getCallArgument();
            Intrinsics.checkNotNullExpressionValue((Object)funcCallArgument, (String)"getCallArgument(...)");
            FuncExpression funcExpression = (FuncExpression)CollectionsKt.firstOrNull(FuncCallArgumentKt.collectArguments(funcCallArgument));
            String string = funcExpression != null ? funcExpression.getText() : null;
            if (string == null) {
                return;
            }
            String argument = string;
            FuncPsiFactory psiFactory = FuncPsiFactory.Companion.get(project);
            if (element.getIfnotKeyword() != null) {
                String string2 = StringsKt.removeSurrounding((String)argument, (CharSequence)"(", (CharSequence)")");
                String string3 = condition.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                funcStatement = psiFactory.createStatement("throw_unless(" + string2 + ", " + StringsKt.removeSurrounding((String)string3, (CharSequence)"(", (CharSequence)")") + ");");
            } else {
                String string4 = StringsKt.removeSurrounding((String)argument, (CharSequence)"(", (CharSequence)")");
                String string5 = condition.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                funcStatement = psiFactory.createStatement("throw_if(" + string4 + ", " + StringsKt.removeSurrounding((String)string5, (CharSequence)"(", (CharSequence)")") + ");");
            }
            FuncStatement newExpression = funcStatement;
            FuncStatement replaced = this.replaceWith(element, newExpression, psiFactory);
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block6;
            editor2.moveToOffset(UtilsKt.getStartOffset((PsiElement)replaced));
        }
    }

    private final FuncStatement replaceWith(FuncIfStatement $this$replaceWith, FuncStatement newExpression, FuncPsiFactory psiFactory) {
        PsiElement parent = $this$replaceWith.getParent();
        FuncElse elseBranch = $this$replaceWith.getElse();
        FuncElseIf elseIfBranch = $this$replaceWith.getElseIf();
        if (elseBranch != null || elseIfBranch != null) {
            throw new NotImplementedError(null, 1, null);
        }
        PsiElement psiElement = $this$replaceWith.replace(newExpression);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.ton.intellij.func.psi.FuncStatement");
        return (FuncStatement)psiElement;
    }

    private final FuncCallExpression getCallExpression(FuncIfStatement $this$getCallExpression) {
        FuncStatement funcStatement;
        block4: {
            block3: {
                funcStatement = $this$getCallExpression.getBlockStatement();
                if (funcStatement == null) break block3;
                FuncBlockStatement it = funcStatement;
                boolean bl = false;
                List<FuncStatement> list = it.getStatementList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatementList(...)");
                Object object = CollectionsKt.firstOrNull(list);
                FuncExpressionStatement funcExpressionStatement = object instanceof FuncExpressionStatement ? (FuncExpressionStatement)object : null;
                funcStatement = funcExpressionStatement;
                if (funcExpressionStatement != null) break block4;
            }
            return null;
        }
        FuncStatement expression = funcStatement;
        FuncExpression it = expression.getExpression();
        boolean bl = false;
        return it instanceof FuncCallExpression ? (FuncCallExpression)it : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ton/intellij/func/inspection/FuncReplaceGuardClauseWithFunctionCallInspection$Companion;", "", "()V", "THROW_FUNCTION", "", "intellij-ton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

