/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.func.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.func.inspection.FuncInspectionBase;
import org.ton.intellij.func.psi.FuncFunction;
import org.ton.intellij.func.psi.FuncFunctionParameter;
import org.ton.intellij.func.psi.FuncVisitor;
import org.ton.intellij.func.psi.impl.FuncFunctionImplKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/ton/intellij/func/inspection/FuncUnusedFunctionParameterInspection;", "Lorg/ton/intellij/func/inspection/FuncInspectionBase;", "()V", "buildFuncVisitor", "Lorg/ton/intellij/func/psi/FuncVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij-ton"})
public final class FuncUnusedFunctionParameterInspection
extends FuncInspectionBase {
    @Override
    @NotNull
    protected FuncVisitor buildFuncVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new FuncVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitFunction(@NotNull FuncFunction o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (FuncFunctionImplKt.getHasAsm(o)) {
                    return;
                }
                List<FuncFunctionParameter> list = o.getFunctionParameterList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getFunctionParameterList(...)");
                List<FuncFunctionParameter> parameters = list;
                for (FuncFunctionParameter parameter : parameters) {
                    ProgressIndicatorProvider.checkCanceled();
                    Intrinsics.checkNotNull((Object)parameter);
                    this.processParameter(parameter);
                }
            }

            private final void processParameter(FuncFunctionParameter parameter) {
                PsiElement psiElement = parameter.getIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement id = psiElement;
                if (ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findFirst() == null) {
                    TextRange textRange = TextRange.from((int)id.getStartOffsetInParent(), (int)id.getTextLength());
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                    TextRange range = textRange;
                    this.$holder.registerProblem((PsiElement)parameter, "Unused parameter <code>#ref</code> #loc", ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[0]);
                }
            }
        };
    }
}

