/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.markdown;

import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.ton.intellij.markdown.MarkdownDocTextMap;
import org.ton.intellij.markdown.MarkdownPsiFactory;
import org.ton.intellij.markdown.Piece;
import org.ton.intellij.markdown.PieceKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u001c\u0010\u0014\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0014\u0010\u0014\u001a\u00020\f*\u00020\u00172\u0006\u0010\u0016\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/ton/intellij/markdown/MarkdownDocAstBuilder;", "", "textMap", "Lorg/ton/intellij/markdown/MarkdownDocTextMap;", "charTable", "Lcom/intellij/util/CharTable;", "psiFactory", "Lorg/ton/intellij/markdown/MarkdownPsiFactory;", "(Lorg/ton/intellij/markdown/MarkdownDocTextMap;Lcom/intellij/util/CharTable;Lorg/ton/intellij/markdown/MarkdownPsiFactory;)V", "prevNodeEnd", "", "buildTree", "", "root", "Lcom/intellij/psi/impl/source/tree/CompositeElement;", "markdownRoot", "Lorg/intellij/markdown/ast/ASTNode;", "visitNode", "parent", "markdownNode", "insertLeaves", "startOffset", "endOffset", "Lcom/intellij/psi/impl/source/tree/TreeElement;", "Companion", "intellij-ton"})
@SourceDebugExtension(value={"SMAP\nMarkdownDoc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownDoc.kt\norg/ton/intellij/markdown/MarkdownDocAstBuilder\n+ 2 MarkdownDoc.kt\norg/ton/intellij/markdown/MarkdownDocTextMap\n*L\n1#1,310:1\n134#2,9:311\n*S KotlinDebug\n*F\n+ 1 MarkdownDoc.kt\norg/ton/intellij/markdown/MarkdownDocAstBuilder\n*L\n73#1:311,9\n*E\n"})
public final class MarkdownDocAstBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkdownDocTextMap textMap;
    @NotNull
    private final CharTable charTable;
    @NotNull
    private final MarkdownPsiFactory psiFactory;
    private int prevNodeEnd;

    private MarkdownDocAstBuilder(MarkdownDocTextMap textMap, CharTable charTable, MarkdownPsiFactory psiFactory) {
        this.textMap = textMap;
        this.charTable = charTable;
        this.psiFactory = psiFactory;
    }

    public final void buildTree(@NotNull CompositeElement root, @NotNull org.intellij.markdown.ast.ASTNode markdownRoot) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)markdownRoot, (String)"markdownRoot");
        for (org.intellij.markdown.ast.ASTNode markdownChild : markdownRoot.getChildren()) {
            this.visitNode(root, markdownChild);
        }
        if (this.prevNodeEnd < this.textMap.getOriginalText().length()) {
            this.insertLeaves(root, this.prevNodeEnd, this.textMap.getOriginalText().length());
        }
    }

    private final void visitNode(CompositeElement parent, org.intellij.markdown.ast.ASTNode markdownNode) {
        IElementType markdownType = markdownNode.getType();
        TreeElement node = this.psiFactory.buildComposite(markdownType);
        if (node == null) {
            if (!(markdownNode instanceof LeafASTNode)) {
                for (org.intellij.markdown.ast.ASTNode markdownChild : markdownNode.getChildren()) {
                    this.visitNode(parent, markdownChild);
                }
            }
            return;
        }
        this.insertLeaves((TreeElement)parent, markdownNode.getStartOffset());
        parent.rawAddChildrenWithoutNotifications(node);
        if (node instanceof CompositeElement) {
            for (org.intellij.markdown.ast.ASTNode markdownChild : markdownNode.getChildren()) {
                this.visitNode((CompositeElement)node, markdownChild);
            }
        }
        this.insertLeaves(node, markdownNode.getEndOffset());
    }

    private final void insertLeaves(CompositeElement $this$insertLeaves, int startOffset, int endOffset) {
        MarkdownDocTextMap this_$iv = this.textMap;
        boolean $i$f$processPiecesInRange = false;
        int offset$iv = 0;
        for (Piece p$iv : MarkdownDocTextMap.access$getPieces$p(this_$iv)) {
            int pieceEndOffset$iv = offset$iv + p$iv.getStr().length();
            if (startOffset < pieceEndOffset$iv && endOffset - offset$iv > 0) {
                Piece piece = p$iv.cut(startOffset - offset$iv, endOffset - offset$iv);
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.charTable.intern(piece.getStr()), (String)"intern(...)");
                LeafPsiElement element = switch (WhenMappings.$EnumSwitchMapping$0[piece.getKind().ordinal()]) {
                    case 1 -> {
                        CharSequence internedText;
                        yield this.psiFactory.createText(internedText);
                    }
                    case 2 -> {
                        CharSequence internedText;
                        yield this.psiFactory.createGap(internedText);
                    }
                    case 3 -> {
                        CharSequence internedText;
                        yield (LeafPsiElement)new PsiWhiteSpaceImpl(internedText);
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                $this$insertLeaves.rawAddChildrenWithoutNotifications((TreeElement)element);
            }
            offset$iv += p$iv.getStr().length();
        }
    }

    private final void insertLeaves(TreeElement $this$insertLeaves, int endOffset) {
        int endOffsetMapped = this.textMap.mapOffsetFromMarkdown(endOffset);
        if (endOffsetMapped != this.prevNodeEnd && $this$insertLeaves instanceof CompositeElement) {
            this.insertLeaves((CompositeElement)$this$insertLeaves, this.prevNodeEnd, endOffsetMapped);
        }
        this.prevNodeEnd = endOffsetMapped;
    }

    public /* synthetic */ MarkdownDocAstBuilder(MarkdownDocTextMap textMap, CharTable charTable, MarkdownPsiFactory psiFactory, DefaultConstructorMarker $constructor_marker) {
        this(textMap, charTable, psiFactory);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/ton/intellij/markdown/MarkdownDocAstBuilder$Companion;", "", "()V", "build", "Lcom/intellij/lang/ASTNode;", "text", "", "charTable", "Lcom/intellij/util/CharTable;", "prefix", "", "psiFactory", "Lorg/ton/intellij/markdown/MarkdownPsiFactory;", "renderHtml", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "intellij-ton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String renderHtml(@NotNull CharSequence text, @NotNull String prefix, @NotNull MarkdownFlavourDescriptor flavour) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
            MarkdownDocTextMap textMap = MarkdownDocTextMap.Companion.invoke(text, prefix);
            org.intellij.markdown.ast.ASTNode markdownRoot = new MarkdownParser(flavour).buildMarkdownTreeFromString(textMap.getMappedText());
            return HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(textMap.getMappedText(), markdownRoot, flavour, false, 8, null), null, (int)1, null);
        }

        @NotNull
        public final ASTNode build(@NotNull CharSequence text, @NotNull CharTable charTable, @NotNull String prefix, @NotNull MarkdownPsiFactory psiFactory) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)charTable, (String)"charTable");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
            MarkdownDocTextMap textMap = MarkdownDocTextMap.Companion.invoke(text, prefix);
            CompositeElement root = psiFactory.createRoot();
            org.intellij.markdown.ast.ASTNode markdownRoot = new MarkdownParser((MarkdownFlavourDescriptor)new CommonMarkFlavourDescriptor(false, false, 3, null)).buildMarkdownTreeFromString(textMap.getMappedText());
            new MarkdownDocAstBuilder(textMap, charTable, psiFactory, null).buildTree(root, markdownRoot);
            TreeElement treeElement = root.getFirstChildNode();
            Intrinsics.checkNotNullExpressionValue((Object)treeElement, (String)"getFirstChildNode(...)");
            return (ASTNode)treeElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PieceKind.values().length];
            try {
                nArray[PieceKind.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PieceKind.GAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PieceKind.WHITESPACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

