/*
 * Decompiled with CFR 0.152.
 */
package org.ton.intellij.markdown;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.intellij.markdown.DocLine;
import org.ton.intellij.markdown.Piece;
import org.ton.intellij.markdown.PieceKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00180\u001cH\u0086\b\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lorg/ton/intellij/markdown/MarkdownDocTextMap;", "", "originalText", "", "mappedText", "", "offsetMap", "", "pieces", "", "Lorg/ton/intellij/markdown/Piece;", "(Ljava/lang/CharSequence;Ljava/lang/String;[ILjava/util/List;)V", "getMappedText", "()Ljava/lang/String;", "getOriginalText", "()Ljava/lang/CharSequence;", "mapFully", "range", "Lcom/intellij/openapi/util/TextRange;", "mapOffsetFromMarkdown", "", "offset", "mapTextRangeFromMarkdownToRust", "processPiecesInRange", "", "startOffset", "endOffset", "processor", "Lkotlin/Function1;", "Companion", "intellij-ton"})
@SourceDebugExtension(value={"SMAP\nMarkdownDoc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownDoc.kt\norg/ton/intellij/markdown/MarkdownDocTextMap\n*L\n1#1,310:1\n134#1,9:311\n*S KotlinDebug\n*F\n+ 1 MarkdownDoc.kt\norg/ton/intellij/markdown/MarkdownDocTextMap\n*L\n145#1:311,9\n*E\n"})
final class MarkdownDocTextMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence originalText;
    @NotNull
    private final String mappedText;
    @NotNull
    private final int[] offsetMap;
    @NotNull
    private final List<Piece> pieces;

    private MarkdownDocTextMap(CharSequence originalText, String mappedText, int[] offsetMap, List<Piece> pieces) {
        this.originalText = originalText;
        this.mappedText = mappedText;
        this.offsetMap = offsetMap;
        this.pieces = pieces;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    @NotNull
    public final String getMappedText() {
        return this.mappedText;
    }

    public final int mapOffsetFromMarkdown(int offset) {
        return this.offsetMap[offset];
    }

    private final TextRange mapTextRangeFromMarkdownToRust(TextRange range) {
        return new TextRange(this.mapOffsetFromMarkdown(range.getStartOffset()), this.mapOffsetFromMarkdown(range.getEndOffset()));
    }

    public final void processPiecesInRange(int startOffset, int endOffset, @NotNull Function1<? super Piece, Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        boolean $i$f$processPiecesInRange = false;
        int offset = 0;
        for (Piece p : this.pieces) {
            int pieceEndOffset = offset + p.getStr().length();
            if (startOffset < pieceEndOffset && endOffset - offset > 0) {
                processor.invoke((Object)p.cut(startOffset - offset, endOffset - offset));
            }
            offset += p.getStr().length();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CharSequence mapFully(@NotNull TextRange range) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        MarkdownDocTextMap markdownDocTextMap = this;
        int n = range.getStartOffset();
        int endOffset$iv = range.getEndOffset();
        boolean $i$f$processPiecesInRange = false;
        int offset$iv = 0;
        for (Piece p$iv : ((MarkdownDocTextMap)this_$iv).pieces) {
            void startOffset$iv;
            int pieceEndOffset$iv = offset$iv + p$iv.getStr().length();
            if (startOffset$iv < pieceEndOffset$iv && endOffset$iv - offset$iv > 0) {
                Piece it = p$iv.cut((int)(startOffset$iv - offset$iv), endOffset$iv - offset$iv);
                boolean bl = false;
                return it.getKind() == PieceKind.TEXT && it.getStr().length() == range.getLength() ? it.getStr() : null;
            }
            offset$iv += p$iv.getStr().length();
        }
        return null;
    }

    public /* synthetic */ MarkdownDocTextMap(CharSequence originalText, String mappedText, int[] offsetMap, List pieces, DefaultConstructorMarker $constructor_marker) {
        this(originalText, mappedText, offsetMap, pieces);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002J\u001a\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u001a\u0010\u000e\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/ton/intellij/markdown/MarkdownDocTextMap$Companion;", "", "()V", "invoke", "Lorg/ton/intellij/markdown/MarkdownDocTextMap;", "text", "", "prefix", "", "mergeOrAddGapWithWS", "", "", "Lorg/ton/intellij/markdown/Piece;", "str", "mergeOrAddWS", "gap", "intellij-ton"})
    @SourceDebugExtension(value={"SMAP\nMarkdownDoc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownDoc.kt\norg/ton/intellij/markdown/MarkdownDocTextMap$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,310:1\n1313#2,2:311\n1726#3,3:313\n*S KotlinDebug\n*F\n+ 1 MarkdownDoc.kt\norg/ton/intellij/markdown/MarkdownDocTextMap$Companion\n*L\n158#1:311,2\n192#1:313,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownDocTextMap invoke(@NotNull CharSequence text, @NotNull String prefix) {
            boolean bl;
            int[] map;
            StringBuilder mappedText;
            List pieces;
            block12: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                pieces = new ArrayList();
                mappedText = new StringBuilder();
                map = new int[text.length() + 1];
                int textPosition = 0;
                Sequence<DocLine> $this$forEach$iv = DocLine.Companion.removePrefix(text, prefix);
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean hasLineBreak;
                    DocLine line = (DocLine)element$iv;
                    boolean bl2 = false;
                    if (line.getHasPrefix()) {
                        CharSequence prefix2 = line.getPrefix();
                        textPosition += prefix2.length();
                        Companion.mergeOrAddGapWithWS(pieces, prefix2);
                    }
                    if (line.getHasContent()) {
                        CharSequence content = line.getContent();
                        int n = content.length();
                        for (int i = 0; i < n; ++i) {
                            map[mappedText.length() + i] = textPosition + i;
                        }
                        map[mappedText.length() + content.length()] = textPosition + content.length();
                        textPosition += content.length();
                        mappedText.append(content);
                        ((Collection)pieces).add(new Piece(content, PieceKind.TEXT));
                    }
                    boolean bl3 = hasLineBreak = !line.isLastLine() && !line.getHasSuffix();
                    if (hasLineBreak) {
                        if (!line.isRemoved()) {
                            map[mappedText.length()] = textPosition;
                            map[mappedText.length() + 1] = textPosition + 1;
                            mappedText.append("\n");
                        }
                        ++textPosition;
                        Companion.mergeOrAddWS(pieces, "\n");
                    }
                    if (!line.getHasSuffix()) continue;
                    CharSequence suffix = line.getSuffix();
                    textPosition += suffix.length();
                    Companion.mergeOrAddGapWithWS(pieces, suffix);
                }
                if (!(mappedText.length() <= text.length())) {
                    String $i$f$forEach2 = "Check failed.";
                    throw new IllegalStateException($i$f$forEach2.toString());
                }
                if (!(mappedText.length() < map.length)) {
                    String $i$f$forEach2 = "Check failed.";
                    throw new IllegalStateException($i$f$forEach2.toString());
                }
                Iterable $this$all$iv = (Iterable)StringsKt.getIndices((CharSequence)mappedText);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl4 = false;
                        if (map[it + 1] > map[it]) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            String string = mappedText.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new MarkdownDocTextMap(text, string, map, pieces, null);
        }

        private final void mergeOrAddGapWithWS(List<Piece> $this$mergeOrAddGapWithWS, CharSequence str) {
            int gapStart = CharArrayUtil.shiftForward((CharSequence)str, (int)0, (String)"\n\t ");
            if (gapStart != 0) {
                this.mergeOrAddWS($this$mergeOrAddGapWithWS, str.subSequence(0, gapStart));
            }
            if (gapStart != str.length()) {
                int gapEnd = CharArrayUtil.shiftBackward((CharSequence)str, (int)gapStart, (int)StringsKt.getLastIndex((CharSequence)str), (String)"\n\t ") + 1;
                CharSequence gapText = str.subSequence(gapStart, gapEnd);
                if (!(gapText.length() > 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                ((Collection)$this$mergeOrAddGapWithWS).add(new Piece(gapText, PieceKind.GAP));
                if (gapEnd != str.length()) {
                    this.mergeOrAddWS($this$mergeOrAddGapWithWS, str.subSequence(gapEnd, str.length()));
                }
            }
        }

        private final void mergeOrAddWS(List<Piece> $this$mergeOrAddWS, CharSequence gap) {
            Piece piece = (Piece)CollectionsKt.lastOrNull($this$mergeOrAddWS);
            if ((piece != null ? piece.getKind() : null) == PieceKind.WHITESPACE) {
                $this$mergeOrAddWS.set(CollectionsKt.getLastIndex($this$mergeOrAddWS), new Piece("" + $this$mergeOrAddWS.get(CollectionsKt.getLastIndex($this$mergeOrAddWS)).getStr() + gap, PieceKind.WHITESPACE));
            } else {
                ((Collection)$this$mergeOrAddWS).add(new Piece(gap, PieceKind.WHITESPACE));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

